/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.logging;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.List;

final class VeMetadataExtensionRegistry {
    private final SoyTypeRegistry typeRegistry;

    VeMetadataExtensionRegistry(SoyTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    ExtensionRegistry createRegistry() {
        ExtensionRegistry registry = ExtensionRegistry.newInstance();
        for (Descriptors.FileDescriptor descriptor : this.typeRegistry.getProtoDescriptors()) {
            VeMetadataExtensionRegistry.addAllExtensions(registry, descriptor.getExtensions());
            VeMetadataExtensionRegistry.visitAllMessages(registry, descriptor.getMessageTypes());
        }
        return registry;
    }

    private static void addAllExtensions(ExtensionRegistry registry, List<Descriptors.FieldDescriptor> extensions) {
        for (Descriptors.FieldDescriptor extension : extensions) {
            VeMetadataExtensionRegistry.addExtension(registry, extension);
        }
    }

    private static void addExtension(ExtensionRegistry registry, Descriptors.FieldDescriptor extension) {
        if (extension.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            registry.add(extension, (Message)DynamicMessage.getDefaultInstance((Descriptors.Descriptor)extension.getMessageType()));
        } else {
            registry.add(extension);
        }
    }

    private static void visitAllMessages(ExtensionRegistry registry, List<Descriptors.Descriptor> messages) {
        for (Descriptors.Descriptor message : messages) {
            VeMetadataExtensionRegistry.visitMessage(registry, message);
        }
    }

    private static void visitMessage(ExtensionRegistry registry, Descriptors.Descriptor message) {
        VeMetadataExtensionRegistry.addAllExtensions(registry, message.getExtensions());
        VeMetadataExtensionRegistry.visitAllMessages(registry, message.getNestedTypes());
    }
}

