/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.AliasUtils;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsSrcNameGenerators;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.internal.VeLogFunction;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.passes.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.shared.RangeArgs;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.JsImplNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.ConstVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnknownType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;

public class GenJsCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    protected final SoyJsSrcOptions jsSrcOptions;
    protected final JavaScriptValueFactoryImpl javaScriptValueFactory;
    private final DelTemplateNamer delTemplateNamer;
    protected final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    JsCodeBuilder jsCodeBuilder;
    protected GenJsExprsVisitor genJsExprsVisitor;
    @VisibleForTesting
    GenJsCodeVisitorAssistantForMsgs assistantForMsgs;
    protected FileSetMetadata fileSetMetadata;
    private final SoyTypeRegistry typeRegistry;
    protected ErrorReporter errorReporter;
    protected SoyToJsVariableMappings topLevelSymbols;
    protected TranslationContext templateTranslationContext;
    protected List<Statement> staticVarDeclarations;
    protected boolean generatePositionalParamsSignature;
    protected Expression dataSource = JsRuntime.OPT_DATA;
    protected TemplateAliases templateAliases;

    protected GenJsCodeVisitor(SoyJsSrcOptions jsSrcOptions, JavaScriptValueFactoryImpl javaScriptValueFactory, DelTemplateNamer delTemplateNamer, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory, SoyTypeRegistry typeRegistry) {
        this.jsSrcOptions = jsSrcOptions;
        this.javaScriptValueFactory = javaScriptValueFactory;
        this.delTemplateNamer = delTemplateNamer;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.typeRegistry = typeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> gen(SoyFileSetNode node, FileSetMetadata registry, ErrorReporter errorReporter) {
        this.fileSetMetadata = (FileSetMetadata)Preconditions.checkNotNull((Object)registry);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        try {
            this.jsFilesContents = new ArrayList<String>();
            this.jsCodeBuilder = null;
            this.genJsExprsVisitor = null;
            this.assistantForMsgs = null;
            this.visit(node);
            List<String> list = this.jsFilesContents;
            return list;
        }
        finally {
            this.fileSetMetadata = null;
            this.errorReporter = null;
        }
    }

    @Override
    @Deprecated
    public final List<String> exec(SoyNode node) {
        throw new UnsupportedOperationException();
    }

    public void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    public Statement visitForUseByAssistantsAsCodeChunk(SoyNode node) {
        return this.doVisitReturningCodeChunk(node, false);
    }

    @VisibleForTesting
    void visitForTesting(SoyNode node, FileSetMetadata registry, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.fileSetMetadata = registry;
        this.topLevelSymbols = SoyToJsVariableMappings.newEmpty();
        this.visit(node);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        if (node.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec((SoyNode)node.getChild(0))).booleanValue()) {
            this.jsCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList<Expression> consecChunks = new ArrayList<Expression>();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) {
                consecChunks.addAll(this.genJsExprsVisitor.exec(child));
                continue;
            }
            if (!consecChunks.isEmpty()) {
                this.jsCodeBuilder.addChunksToOutputVar(consecChunks);
                consecChunks.clear();
            }
            this.visit(child);
        }
        if (!consecChunks.isEmpty()) {
            this.jsCodeBuilder.addChunksToOutputVar(consecChunks);
            consecChunks.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    protected JsCodeBuilder createCodeBuilder() {
        return new JsCodeBuilder();
    }

    protected JsCodeBuilder createChildJsCodeBuilder() {
        return new JsCodeBuilder(this.jsCodeBuilder);
    }

    protected JsCodeBuilder getJsCodeBuilder() {
        return this.jsCodeBuilder;
    }

    protected Statement visitChildrenReturningCodeChunk(SoyNode.ParentSoyNode<?> node) {
        return this.doVisitReturningCodeChunk(node, true);
    }

    private Statement doVisitReturningCodeChunk(SoyNode node, boolean visitChildren) {
        JsCodeBuilder original = this.jsCodeBuilder;
        this.jsCodeBuilder = this.createChildJsCodeBuilder();
        this.jsCodeBuilder.setIndent(0);
        if (visitChildren) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        } else {
            this.visit(node);
        }
        Statement chunk = Statement.treatRawStringAsStatementLegacyOnly(this.jsCodeBuilder.getCode(), this.jsCodeBuilder.googRequires());
        this.jsCodeBuilder = original;
        return chunk;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        StringBuilder file = new StringBuilder();
        file.append("// This file was automatically generated by the Soy compiler.\n").append("// Please don't edit this file by hand.\n").append("// source: ").append(node.getFilePath().path()).append('\n');
        if (node.getConstants().isEmpty() && node.getExterns().isEmpty() && node.getTemplates().isEmpty()) {
            this.jsFilesContents.add(file.toString());
            this.jsCodeBuilder = null;
            return;
        }
        file.append("\n");
        String fileOverviewDescription = "Templates in namespace " + node.getNamespace() + ".";
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        jsDocBuilder.addAnnotation("fileoverview", fileOverviewDescription);
        jsDocBuilder.addAnnotation("suppress", "{missingRequire} TODO(b/152440355)");
        if (node.getTemplates().stream().anyMatch(tmpl -> tmpl instanceof TemplateElementNode)) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "extraRequire");
        }
        if (node.getDelPackageName() != null) {
            jsDocBuilder.addParameterizedAnnotation("modName", node.getDelPackageName());
        }
        this.addJsDocToProvideDelTemplates(jsDocBuilder, node);
        this.addJsDocToRequireDelTemplates(jsDocBuilder, node);
        this.addCodeToRequireCss(jsDocBuilder, node);
        jsDocBuilder.addAnnotation("public");
        file.append(jsDocBuilder.build());
        file.append("\n\n");
        this.templateAliases = AliasUtils.IDENTITY_ALIASES;
        this.jsCodeBuilder = this.createCodeBuilder();
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            this.templateAliases = AliasUtils.createTemplateAliases(node, this.fileSetMetadata);
            this.addCodeToDeclareGoogModule(file, node);
            this.addCodeToRequireGoogModules(node);
        } else if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            GenJsCodeVisitor.addCodeToProvideSoyNamespace(file, node);
            file.append('\n');
            this.addCodeToRequireSoyNamespaces(node);
        } else {
            throw new AssertionError((Object)"impossible");
        }
        Map<String, SoyType> ijData = this.getAllIjDataParams(node);
        if (!ijData.isEmpty()) {
            GoogRequire require = this.jsSrcOptions.shouldGenerateGoogModules() ? JsRuntime.GOOG_SOY_ALIAS : JsRuntime.GOOG_SOY;
            this.jsCodeBuilder.appendLine(new String[0]);
            for (Map.Entry<String, SoyType> entry : ijData.entrySet()) {
                this.jsCodeBuilder.appendLine(new String[0]);
                this.jsCodeBuilder.appendLine(JsDoc.builder().addParameterizedAnnotation("suppress", "duplicate").addParameterizedAnnotation("type", this.getJsTypeForParamForDeclaration(entry.getValue()).typeExpr() + "|undefined").build().toString());
                this.jsCodeBuilder.append(require.reference().dotAccess("IjData").dotAccess("prototype").dotAccess(entry.getKey()).asStatement());
            }
        }
        this.topLevelSymbols = SoyToJsVariableMappings.newEmpty();
        for (ImportNode importNode : node.getImports()) {
            this.visit(importNode);
        }
        UniqueNameGenerator nameGenerator = JsSrcNameGenerators.forLocalVariables();
        CodeChunk.Generator codeGenerator = CodeChunk.Generator.create(nameGenerator);
        this.templateTranslationContext = TranslationContext.of(this.topLevelSymbols, codeGenerator, nameGenerator);
        for (ConstNode constant : node.getConstants()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit(constant);
        }
        node.getExterns().stream().map(ExternNode::getJsImpl).flatMap(Streams::stream).forEach(jsExtern -> {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit((SoyNode)jsExtern);
        });
        for (TemplateNode template : node.getTemplates()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.staticVarDeclarations = new ArrayList<Statement>();
            this.visit(template);
            if (this.staticVarDeclarations.isEmpty()) continue;
            this.jsCodeBuilder.append(Statement.of(this.staticVarDeclarations));
        }
        this.jsCodeBuilder.appendGoogRequiresTo(file);
        this.jsCodeBuilder.appendCodeTo(file);
        this.jsFilesContents.add(file.toString());
        this.jsCodeBuilder = null;
    }

    private Map<String, SoyType> getAllIjDataParams(SoyFileNode node) {
        LinkedHashMap<String, SoyType> params = new LinkedHashMap<String, SoyType>();
        for (TemplateNode template : node.getTemplates()) {
            for (TemplateParam param : template.getInjectedParams()) {
                SoyType oldType = params.put(param.name(), param.type());
                if (oldType == null) continue;
                params.put(param.name(), this.typeRegistry.getOrCreateUnionType(Arrays.asList(param.type(), oldType)));
            }
        }
        return params;
    }

    private void addCodeToRequireCss(JsDoc.Builder header, SoyFileNode soyFile) {
        TreeSet<String> requiredCssNamespaces = new TreeSet<String>();
        if (this.jsSrcOptions.dependOnCssHeader()) {
            requiredCssNamespaces.add("./" + soyFile.getFilePath().fileName());
        } else {
            requiredCssNamespaces.addAll((Collection<String>)soyFile.getRequireCss());
            for (TemplateNode template : soyFile.getTemplates()) {
                requiredCssNamespaces.addAll((Collection<String>)template.getRequiredCssNamespaces());
            }
        }
        for (String requiredCssNamespace : requiredCssNamespaces) {
            header.addParameterizedAnnotation("requirecss", requiredCssNamespace);
        }
    }

    private static void addCodeToProvideSoyNamespace(StringBuilder header, SoyFileNode soyFile) {
        header.append("goog.provide('").append(soyFile.getNamespace()).append("');\n");
    }

    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace;
    }

    private void addCodeToDeclareGoogModule(StringBuilder header, SoyFileNode soyFile) {
        String exportNamespace = this.getGoogModuleNamespace(soyFile.getNamespace());
        header.append("goog.module('").append(exportNamespace).append("');\n\n");
    }

    private void addCodeToRequireGoogModules(SoyFileNode soyFile) {
        soyFile.getImports().stream().filter(i -> i.getImportType() == ImportNode.ImportType.TEMPLATE).map(i -> this.namespaceForPath(i.getSourceFilePath())).distinct().sorted().forEach(calleeNamespace -> {
            String namespaceAlias = this.templateAliases.getNamespaceAlias((String)calleeNamespace);
            String importNamespace = this.getGoogModuleNamespace((String)calleeNamespace);
            this.jsCodeBuilder.append(VariableDeclaration.builder(namespaceAlias).setRhs(JsRuntime.GOOG_REQUIRE.call(Expression.stringLiteral(importNamespace))).build());
        });
    }

    private void addJsDocToProvideDelTemplates(JsDoc.Builder header, SoyFileNode soyFile) {
        TreeSet<String> delTemplateNames = new TreeSet<String>();
        for (TemplateNode template : soyFile.getTemplates()) {
            if (!(template instanceof TemplateDelegateNode)) continue;
            delTemplateNames.add(this.delTemplateNamer.getDelegateName((TemplateDelegateNode)template));
        }
        for (String delTemplateName : delTemplateNames) {
            header.addParameterizedAnnotation("hassoydeltemplate", delTemplateName);
        }
    }

    private void addJsDocToRequireDelTemplates(JsDoc.Builder header, SoyFileNode soyFile) {
        TreeSet<String> delTemplateNames = new TreeSet<String>();
        for (CallDelegateNode delCall : SoyTreeUtils.getAllNodesOfType(soyFile, CallDelegateNode.class)) {
            delTemplateNames.add(this.delTemplateNamer.getDelegateName(delCall));
        }
        for (String delTemplateName : delTemplateNames) {
            header.addParameterizedAnnotation("hassoydelcall", delTemplateName);
        }
    }

    private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
        soyFile.getImports().stream().filter(i -> i.getImportType() == ImportNode.ImportType.TEMPLATE).map(i -> this.namespaceForPath(i.getSourceFilePath())).distinct().sorted().forEach(calleeNamespace -> this.jsCodeBuilder.addGoogRequire(GoogRequire.create(calleeNamespace)));
    }

    protected String getTemplateReturnType(TemplateNode node) {
        return node.getContentKind() == SanitizedContentKind.TEXT ? "string" : "!" + NodeContentKinds.toJsSanitizedContentCtorName(node.getContentKind());
    }

    @Override
    protected void visitImportNode(ImportNode node) {
        node.visitVars((var, parentType) -> {
            if (parentType != null && parentType.getKind() == SoyType.Kind.TEMPLATE_MODULE && var.type().getKind() != SoyType.Kind.TEMPLATE_TYPE) {
                String namespace = this.namespaceForPath(node.getSourceFilePath());
                if (this.jsSrcOptions.shouldGenerateGoogModules()) {
                    namespace = this.templateAliases.getNamespaceAlias(namespace);
                }
                if (var.type().getKind() == SoyType.Kind.FUNCTION) {
                    Expression translation = Expression.dottedIdNoRequire(namespace + "." + var.getSymbol());
                    this.topLevelSymbols.put(var.getSymbol(), translation);
                } else {
                    Expression translation = Expression.dottedIdNoRequire(namespace + "." + var.getSymbol()).call(JsRuntime.SOY_INTERNAL_CALL_MARKER);
                    this.topLevelSymbols.put(var.name(), translation);
                }
            }
        });
    }

    @Override
    protected void visitConstNode(ConstNode node) {
        SoyFileNode file = node.getNearestAncestor(SoyFileNode.class);
        ConstVar var = node.getVar();
        ImmutableList.Builder declarations = ImmutableList.builder();
        JsType varType = this.getJsTypeForParamForDeclaration(var.type());
        JsDoc jsDoc = this.addInternalCallerParam(JsDoc.builder().addAnnotation(node.isExported() ? "public" : "private").addParameterizedAnnotation("return", varType.typeExpr())).build();
        String partialName = var.name();
        String alias = this.jsSrcOptions.shouldGenerateGoogModules() ? partialName : file.getNamespace() + "." + partialName;
        Expression aliasExp = Expression.dottedIdNoRequire(alias);
        Expression constantGetterFunction = Expression.function(jsDoc, Statement.of(JsRuntime.SOY_ARE_YOU_AN_INTERNAL_CALLER.call(Expression.id("$$areYouAnInternalCaller")).asStatement(), Statement.returnValue(this.translateExpr(node.getExpr()).castAs(varType.typeExpr()))));
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            declarations.add((Object)VariableDeclaration.builder(alias).setJsDoc(jsDoc).setRhs(constantGetterFunction).build());
            if (node.isExported()) {
                declarations.add((Object)Statement.assign(JsRuntime.EXPORTS.dotAccess(partialName), aliasExp));
            }
        } else {
            declarations.add((Object)Statement.assign(aliasExp, constantGetterFunction, jsDoc));
        }
        this.jsCodeBuilder.append(Statement.of((Iterable<Statement>)declarations.build()));
        for (GoogRequire require : varType.getGoogRequires()) {
            this.jsCodeBuilder.addGoogRequire(require);
        }
        this.topLevelSymbols.put(var.name(), aliasExp.call(JsRuntime.SOY_INTERNAL_CALL_MARKER));
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        JsDoc jsDoc;
        this.generatePositionalParamsSignature = GenCallCodeUtils.hasPositionalSignature(TemplateMetadata.buildTemplateType(node));
        String templateName = node.getTemplateName();
        String partialName = node.getLocalTemplateSymbol();
        this.dataSource = node instanceof TemplateElementNode && ((TemplateElementNode)node).hasExternalClassDefinition() && this.isIncrementalDom() ? Expression.THIS : JsRuntime.OPT_DATA;
        String alias = this.jsSrcOptions.shouldGenerateGoogModules() && node instanceof TemplateDelegateNode ? partialName : this.templateAliases.get(templateName);
        Expression aliasExp = Expression.dottedIdNoRequire(alias);
        UniqueNameGenerator nameGenerator = JsSrcNameGenerators.forLocalVariables();
        CodeChunk.Generator codeGenerator = CodeChunk.Generator.create(nameGenerator);
        this.templateTranslationContext = TranslationContext.of(SoyToJsVariableMappings.startingWith(this.topLevelSymbols), codeGenerator, nameGenerator);
        this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.templateTranslationContext, this.templateAliases, this.errorReporter, this.dataSource);
        this.assistantForMsgs = null;
        ImmutableList.Builder declarations = ImmutableList.builder();
        if (this.generatePositionalParamsSignature) {
            jsDoc = this.generateFunctionJsDoc(node, alias, true);
            Expression publicFunction = Expression.function(jsDoc, this.generateDelegateFunction(node, alias));
            JsDoc positionalFunctionDoc = this.generatePositionalFunctionJsDoc(node);
            Expression positionalFunction = Expression.function(positionalFunctionDoc, this.generateFunctionBody(node, alias, true));
            if (this.jsSrcOptions.shouldGenerateGoogModules()) {
                VariableDeclaration publicDeclaration = VariableDeclaration.builder(alias).setJsDoc(jsDoc).setRhs(publicFunction).build();
                declarations.add((Object)publicDeclaration);
                VariableDeclaration positionalDeclaration = VariableDeclaration.builder(alias + "$").setJsDoc(positionalFunctionDoc).setRhs(positionalFunction).build();
                declarations.add((Object)positionalDeclaration);
                if (!(node instanceof TemplateDelegateNode) && node.getVisibility() == Visibility.PUBLIC) {
                    declarations.add((Object)Statement.assign(JsRuntime.EXPORTS.dotAccess(partialName), publicDeclaration.ref()));
                    declarations.add((Object)Statement.assign(JsRuntime.EXPORTS.dotAccess(partialName + "$"), positionalDeclaration.ref()));
                }
            } else {
                declarations.add((Object)Statement.assign(aliasExp, publicFunction, jsDoc));
                declarations.add((Object)Statement.assign(Expression.dottedIdNoRequire(alias + "$"), positionalFunction, positionalFunctionDoc));
            }
        } else {
            jsDoc = this.generateFunctionJsDoc(node, alias, false);
            Expression function = Expression.function(jsDoc, this.generateFunctionBody(node, alias, false));
            if (this.jsSrcOptions.shouldGenerateGoogModules()) {
                declarations.add((Object)VariableDeclaration.builder(alias).setJsDoc(jsDoc).setRhs(function).build());
                if (!(node instanceof TemplateDelegateNode) && node.getVisibility() == Visibility.PUBLIC) {
                    declarations.add((Object)Statement.assign(JsRuntime.EXPORTS.dotAccess(partialName), aliasExp));
                }
            } else {
                declarations.add((Object)Statement.assign(aliasExp, function, jsDoc));
            }
        }
        if (!this.hasOnlyImplicitParams(node)) {
            declarations.add((Object)aliasExp.dotAccess("Params").asStatement(JsDoc.builder().addParameterizedAnnotation("typedef", this.genParamsRecordType(node)).build()));
        }
        declarations.add((Object)Statement.ifStatement(JsRuntime.GOOG_DEBUG, Statement.assign(aliasExp.dotAccess("soyTemplateName"), Expression.stringLiteral(templateName), JsDoc.builder().addAnnotation("nocollapse").addParameterizedAnnotation("type", "string").build())).build());
        if (node instanceof TemplateDelegateNode) {
            TemplateDelegateNode nodeAsDelTemplate = (TemplateDelegateNode)node;
            declarations.add((Object)JsRuntime.SOY_REGISTER_DELEGATE_FN.call(JsRuntime.SOY_GET_DELTEMPLATE_ID.call(Expression.stringLiteral(this.delTemplateNamer.getDelegateName(nodeAsDelTemplate))), Expression.stringLiteral(nodeAsDelTemplate.getDelTemplateVariant()), Expression.number(nodeAsDelTemplate.getDelPriority().getValue()), aliasExp).asStatement());
        }
        this.jsCodeBuilder.append(Statement.of((Iterable<Statement>)declarations.build()));
        this.generatePositionalParamsSignature = false;
    }

    protected boolean hasOnlyImplicitParams(TemplateNode node) {
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            return false;
        }
        return true;
    }

    protected final ImmutableList<TemplateParam> paramsInOrder(TemplateNode node) {
        Map paramsByName = (Map)node.getParams().stream().collect(ImmutableMap.toImmutableMap(AbstractVarDefn::name, param -> param));
        return (ImmutableList)TemplateMetadata.buildTemplateType(node).getActualParameters().stream().map(p -> (TemplateParam)paramsByName.get(p.getName())).collect(ImmutableList.toImmutableList());
    }

    protected final JsDoc.Builder addInternalCallerParam(JsDoc.Builder jsDocBuilder) {
        return jsDocBuilder.addParam("$$areYouAnInternalCaller", "!Object");
    }

    protected JsDoc generatePositionalFunctionJsDoc(TemplateNode node) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        this.addInternalCallerParam(jsDocBuilder);
        this.addIjDataParam(jsDocBuilder, true);
        for (TemplateParam param : this.paramsInOrder(node)) {
            JsType jsType = this.getJsTypeForParamForDeclaration(param.type());
            jsDocBuilder.addParam(this.genParamAlias(param.name()), jsType.typeExpr() + (param.isRequired() ? "" : "="));
        }
        this.addReturnTypeAndAnnotations(node, jsDocBuilder);
        jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        return jsDocBuilder.build();
    }

    protected JsDoc generateFunctionJsDoc(TemplateNode node, String alias, boolean isDelegate) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        if (this.hasOnlyImplicitParams(node)) {
            jsDocBuilder.addParam("opt_data", "?Object<string, *>=");
        } else if (new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            jsDocBuilder.addParam("opt_data", "?" + alias + ".Params=");
        } else {
            jsDocBuilder.addParam("opt_data", "!" + alias + ".Params");
        }
        this.addIjDataParam(jsDocBuilder, false);
        this.addReturnTypeAndAnnotations(node, jsDocBuilder);
        if (!isDelegate) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        } else if (TemplateMetadata.buildTemplateType(node).getActualParameters().stream().anyMatch(TemplateType.Parameter::isImplicit)) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "missingProperties");
        }
        if (node instanceof TemplateElementNode) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "uselessCode");
            jsDocBuilder.addParameterizedAnnotation("suppress", "suspiciousCode");
        }
        return jsDocBuilder.build();
    }

    protected final void addReturnTypeAndAnnotations(TemplateNode node, JsDoc.Builder jsDocBuilder) {
        String returnType = this.getTemplateReturnType(node);
        jsDocBuilder.addParameterizedAnnotation("return", returnType);
        if (node.getVisibility() == Visibility.PRIVATE) {
            jsDocBuilder.addAnnotation("private");
        }
    }

    protected ImmutableList<Expression> templateArguments(TemplateNode node, boolean isPositionalStyle) {
        if (isPositionalStyle) {
            return ImmutableList.of((Object)Expression.objectLiteral((Map)node.getParams().stream().collect(ImmutableMap.toImmutableMap(AbstractVarDefn::name, p -> Expression.id(this.genParamAlias(p.name()))))), (Object)JsRuntime.IJ_DATA);
        }
        return ImmutableList.of((Object)JsRuntime.OPT_DATA, (Object)JsRuntime.IJ_DATA);
    }

    protected final Statement generateStubbingTest(TemplateNode node, String alias, boolean isPositionalStyle) {
        return Statement.ifStatement(JsRuntime.GOOG_DEBUG.and(JsRuntime.SOY_STUBS_MAP.bracketAccess(Expression.stringLiteral(node.getTemplateName())), this.templateTranslationContext.codeGenerator()), Statement.returnValue(JsRuntime.SOY_STUBS_MAP.bracketAccess(Expression.stringLiteral(node.getTemplateName())).call((Iterable<? extends Expression>)this.templateArguments(node, isPositionalStyle)))).build();
    }

    protected void addIjDataParam(JsDoc.Builder jsDocBuilder, boolean forPositionalSignature) {
        GoogRequire googSoy = this.jsSrcOptions.shouldGenerateGoogModules() ? JsRuntime.GOOG_SOY_ALIAS : JsRuntime.GOOG_SOY;
        jsDocBuilder.addGoogRequire(googSoy);
        if (forPositionalSignature) {
            jsDocBuilder.addParam("$ijData", "!" + googSoy.alias() + ".IjData");
        } else {
            jsDocBuilder.addParam("opt_ijData", "(?" + googSoy.alias() + ".IjData|?Object<string, *>)=");
        }
    }

    @CheckReturnValue
    protected Statement generateDelegateFunction(TemplateNode templateNode, String alias) {
        ImmutableList.Builder bodyStatements = ImmutableList.builder();
        if (new ShouldEnsureDataIsDefinedVisitor().exec(templateNode)) {
            bodyStatements.add((Object)Statement.assign(JsRuntime.OPT_DATA, JsRuntime.OPT_DATA.or(Expression.EMPTY_OBJECT_LITERAL, this.templateTranslationContext.codeGenerator())));
        }
        bodyStatements.add((Object)this.redeclareIjData());
        ArrayList<Expression> callParams = new ArrayList<Expression>();
        callParams.addAll((Collection<Expression>)this.getFixedParamsToPositionalCall(templateNode));
        for (TemplateParam param : this.paramsInOrder(templateNode)) {
            callParams.add(this.genCodeForParamAccess(param.name(), param));
        }
        String returnType = this.getTemplateReturnType(templateNode);
        Expression callExpr = Expression.dottedIdNoRequire(alias + "$").call(callParams);
        bodyStatements.add((Object)(returnType.equals("void") ? callExpr.asStatement() : Statement.returnValue(callExpr)));
        return Statement.of((Iterable<Statement>)bodyStatements.build());
    }

    protected ImmutableList<Expression> getFixedParamsToPositionalCall(TemplateNode node) {
        return ImmutableList.of((Object)JsRuntime.SOY_INTERNAL_CALL_MARKER, (Object)JsRuntime.IJ_DATA);
    }

    protected final Statement redeclareIjData() {
        GoogRequire googSoy = this.jsSrcOptions.shouldGenerateGoogModules() ? JsRuntime.GOOG_SOY_ALIAS : JsRuntime.GOOG_SOY;
        return VariableDeclaration.builder("$ijData").setRhs(Expression.id("opt_ijData").castAs("!" + googSoy.alias() + ".IjData")).build();
    }

    @CheckReturnValue
    protected Statement generateFunctionBody(TemplateNode node, String alias, boolean isPositionalStyle) {
        ImmutableList.Builder bodyStatements = ImmutableList.builder();
        if (!isPositionalStyle) {
            bodyStatements.add((Object)this.redeclareIjData());
        } else {
            bodyStatements.add((Object)JsRuntime.SOY_ARE_YOU_AN_INTERNAL_CALLER.call(Expression.id("$$areYouAnInternalCaller")).asStatement());
        }
        bodyStatements.add((Object)this.generateStubbingTest(node, alias, isPositionalStyle));
        if (!isPositionalStyle && new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            bodyStatements.add((Object)Statement.assign(JsRuntime.OPT_DATA, JsRuntime.OPT_DATA.or(Expression.EMPTY_OBJECT_LITERAL, this.templateTranslationContext.codeGenerator())));
        }
        bodyStatements.add((Object)this.genParamTypeChecks(node, alias, isPositionalStyle));
        if (node instanceof TemplateElementNode) {
            TemplateElementNode elementNode = (TemplateElementNode)node;
            for (TemplateStateVar stateVar : elementNode.getStateVars()) {
                Expression expr = (Expression)this.getExprTranslator().exec(stateVar.defaultValue());
                if (!stateVar.type().equals(stateVar.defaultValue().getType())) {
                    expr = expr.castAs(JsType.forJsSrc(stateVar.type()).typeExpr());
                }
                bodyStatements.add((Object)VariableDeclaration.builder(stateVar.name()).setRhs(expr).build());
            }
        }
        SanitizedContentKind kind = node.getContentKind();
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            List<Expression> templateBodyChunks = this.genJsExprsVisitor.exec(node);
            bodyStatements.add((Object)Statement.returnValue(this.sanitize(CodeChunkUtils.concatChunks(templateBodyChunks), kind)));
        } else {
            this.jsCodeBuilder.pushOutputVar("$output");
            Statement codeChunk = this.visitChildrenReturningCodeChunk(node);
            this.jsCodeBuilder.popOutputVar();
            bodyStatements.add((Object)Statement.of(codeChunk, Statement.returnValue(this.sanitize(Expression.id("$output"), kind))));
        }
        return Statement.of((Iterable<Statement>)bodyStatements.build());
    }

    protected final Expression sanitize(Expression templateBody, SanitizedContentKind contentKind) {
        if (contentKind != SanitizedContentKind.TEXT) {
            return JsRuntime.sanitizedContentOrdainerFunction(contentKind).call(templateBody);
        }
        return templateBody;
    }

    protected GenJsCodeVisitorAssistantForMsgs getAssistantForMsgs() {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new GenJsCodeVisitorAssistantForMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter);
        }
        return this.assistantForMsgs;
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        Expression msgVar = this.getAssistantForMsgs().generateMsgGroupVariable(node);
        this.getJsCodeBuilder().addChunkToOutputVar(msgVar);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        Expression value = this.translateExpr(node.getExpr());
        if (value.equals(Expression.LITERAL_NULL)) {
            value = value.castAs(JsType.forJsSrc(node.getVar().type()).typeExpr());
        }
        this.jsCodeBuilder.append(VariableDeclaration.builder(generatedVarName).setRhs(value).build());
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVar(), Expression.id(generatedVarName));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        Expression generatedVar = Expression.id(generatedVarName);
        this.jsCodeBuilder.pushOutputVar(generatedVarName);
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        if (node.getContentKind() != SanitizedContentKind.TEXT) {
            String wrappedVarName = node.getVarName() + "__wrapped" + node.getId();
            this.jsCodeBuilder.append(VariableDeclaration.builder(wrappedVarName).setRhs(JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(generatedVar)).build());
            generatedVar = Expression.id(wrappedVarName);
        }
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVar(), generatedVar);
    }

    @Override
    protected void visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
        } else {
            this.generateNonExpressionIfNode(node);
        }
    }

    protected void generateNonExpressionIfNode(IfNode node) {
        ConditionalBuilder conditional = null;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode condNode = (IfCondNode)child;
                Expression predicate = this.getExprTranslator().maybeCoerceToBoolean(condNode.getExpr().getType(), this.translateExpr(condNode.getExpr()), false);
                Statement consequent = this.visitChildrenReturningCodeChunk(condNode);
                if (conditional == null) {
                    conditional = Statement.ifStatement(predicate, consequent);
                    continue;
                }
                conditional.addElseIf(predicate, consequent);
                continue;
            }
            if (child instanceof IfElseNode) {
                Statement trailingElse = this.visitChildrenReturningCodeChunk((IfElseNode)child);
                conditional.setElse(trailingElse);
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.append(conditional.build());
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        Expression switchOn = this.coerceTypeForSwitchComparison(node.getExpr());
        SwitchBuilder switchBuilder = Statement.switchValue(switchOn);
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                ImmutableList.Builder caseChunks = ImmutableList.builder();
                for (ExprNode caseExpr : scn.getExprList()) {
                    Expression caseChunk = this.translateExpr(caseExpr);
                    caseChunks.add((Object)caseChunk);
                }
                Statement body = this.visitChildrenReturningCodeChunk(scn);
                switchBuilder.addCase((ImmutableList<Expression>)caseChunks.build(), body);
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                Statement body = this.visitChildrenReturningCodeChunk((SwitchDefaultNode)child);
                switchBuilder.setDefault(body);
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.append(switchBuilder.build());
    }

    private Expression coerceTypeForSwitchComparison(ExprRootNode expr) {
        Expression switchOn = this.translateExpr(expr);
        SoyType type = expr.getType();
        if (SoyTypes.makeNullable(StringType.getInstance()).isAssignableFromStrict(type) || type.equals(AnyType.getInstance()) || type.equals(UnknownType.getInstance())) {
            CodeChunk.Generator codeGenerator = this.templateTranslationContext.codeGenerator();
            Expression tmp = codeGenerator.declarationBuilder().setRhs(switchOn).build().ref();
            return Expression.ifExpression(JsRuntime.GOOG_IS_OBJECT.call(tmp), tmp.dotAccess("toString").call(new Expression[0])).setElse(tmp).build(codeGenerator);
        }
        return switchOn;
    }

    protected TranslateExprNodeVisitor getExprTranslator() {
        return new TranslateExprNodeVisitor(this.javaScriptValueFactory, this.templateTranslationContext, this.templateAliases, this.errorReporter, this.dataSource);
    }

    protected Expression translateExpr(ExprNode expr) {
        return (Expression)this.getExprTranslator().exec(expr);
    }

    private Expression genCodeForParamAccess(String paramName, TemplateParam param) {
        return this.getExprTranslator().genCodeForParamAccess(paramName, param);
    }

    @Override
    protected void visitForNode(ForNode node) {
        Function getDataItemFunction;
        Expression limitInitializer;
        boolean hasIfempty = node.numChildren() == 2;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        ForNonemptyNode nonEmptyNode = (ForNonemptyNode)node.getChild(0);
        String varPrefix = nonEmptyNode.getVarName() + node.getId();
        String limitName = varPrefix + "ListLen";
        Optional<RangeArgs> args = RangeArgs.createFromNode(node);
        if (args.isPresent()) {
            RangeArgs range = args.get();
            Expression start = this.maybeStashInLocal(range.start().isPresent() ? this.translateExpr(range.start().get()) : Expression.number(0L), varPrefix + "_RangeStart", statements);
            Expression end = this.maybeStashInLocal(this.translateExpr(range.limit()), varPrefix + "_RangeEnd", statements);
            Expression step = this.maybeStashInLocal(range.increment().isPresent() ? this.translateExpr(range.increment().get()) : Expression.number(1L), varPrefix + "_RangeStep", statements);
            limitInitializer = Expression.dottedIdNoRequire("Math.max").call(Expression.number(0L), Expression.dottedIdNoRequire("Math.ceil").call(end.minus(start).divideBy(step)));
            getDataItemFunction = index -> start.plus(index.times(step));
        } else {
            Expression dataRef = this.translateExpr(node.getExpr());
            String listVarName = varPrefix + "List";
            Expression listVar = VariableDeclaration.builder(listVarName).setRhs(dataRef).build().ref();
            limitInitializer = listVar.dotAccess("length");
            getDataItemFunction = index -> Expression.id(listVarName).bracketAccess((Expression)index);
        }
        Expression limit = Expression.id(limitName);
        statements.add(VariableDeclaration.builder(limitName).setRhs(limitInitializer).build());
        Statement foreachBody = this.handleForeachLoop(nonEmptyNode, limit, (Function<Expression, Expression>)getDataItemFunction);
        if (hasIfempty) {
            Statement ifemptyBody = this.visitChildrenReturningCodeChunk((SoyNode.ParentSoyNode)node.getChild(1));
            Expression limitCheck = limit.op(Operator.GREATER_THAN, Expression.number(0L));
            foreachBody = Statement.ifStatement(limitCheck, foreachBody).setElse(ifemptyBody).build();
        }
        statements.add(foreachBody);
        this.jsCodeBuilder.append(Statement.of(statements));
    }

    private Expression maybeStashInLocal(Expression expr, String varName, List<Statement> statements) {
        if (expr.isCheap()) {
            return expr;
        }
        statements.add(VariableDeclaration.builder(varName).setRhs(expr).build());
        return Expression.id(varName);
    }

    private Statement handleForeachLoop(ForNonemptyNode node, Expression limit, Function<Expression, Expression> getDataItemFunction) {
        String refPrefix = node.getVarRefName();
        String jsLetPrefix = node.getVarName() + node.getForNodeId();
        String loopIndexName = jsLetPrefix + "Index";
        String dataName = jsLetPrefix + "Data";
        Expression loopIndex = Expression.id(loopIndexName);
        VariableDeclaration data = VariableDeclaration.builder(dataName).setRhs((Expression)getDataItemFunction.apply((Object)loopIndex)).build();
        this.templateTranslationContext.soyToJsVariableMappings().put(refPrefix, Expression.id(dataName));
        if (node.getIndexVar() != null) {
            this.templateTranslationContext.soyToJsVariableMappings().put(node.getIndexVar(), Expression.id(loopIndexName));
        }
        Statement foreachBody = Statement.of(data, this.visitChildrenReturningCodeChunk(node));
        return Statement.forLoop(loopIndexName, limit, foreachBody);
    }

    @Override
    protected void visitForNonemptyNode(ForNonemptyNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        Expression call = this.genCallCodeUtils.gen(node, this.templateAliases, this.templateTranslationContext, this.errorReporter, this.getExprTranslator());
        this.jsCodeBuilder.addChunkToOutputVar(call);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder.pushOutputVar("param" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitLogNode(LogNode node) {
        if (this.isComputableAsJsExprsVisitor.execOnChildren(node).booleanValue()) {
            List<Expression> logMsgChunks = this.genJsExprsVisitor.execOnChildren(node);
            this.jsCodeBuilder.append(JsRuntime.WINDOW_CONSOLE_LOG.call(CodeChunkUtils.concatChunks(logMsgChunks)));
        } else {
            String outputVarName = "logMsg_s" + node.getId();
            this.jsCodeBuilder.pushOutputVar(outputVarName);
            this.visitChildren(node);
            this.jsCodeBuilder.popOutputVar();
            this.jsCodeBuilder.append(JsRuntime.WINDOW_CONSOLE_LOG.call(Expression.id(outputVarName)));
        }
    }

    @Override
    protected void visitKeyNode(KeyNode node) {
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
        this.jsCodeBuilder.appendLine("debugger;");
    }

    @Override
    protected void visitVeLogNode(VeLogNode node) {
        if (!node.needsSyntheticVelogNode()) {
            this.visitChildren(node);
            return;
        }
        FunctionNode funcNode = FunctionNode.newPositional(Identifier.create("$$velog", node.getSourceLocation()), VeLogFunction.INSTANCE, node.getSourceLocation());
        funcNode.addChild(node.getVeDataExpression().copy(new CopyState()));
        if (node.getLogonlyExpression() != null) {
            funcNode.addChild(node.getLogonlyExpression().copy(new CopyState()));
        }
        this.jsCodeBuilder.addChunksToOutputVar((List<? extends Expression>)ImmutableList.of((Object)Expression.stringLiteral("<velog"), (Object)((Expression)this.getExprTranslator().exec(funcNode)), (Object)Expression.stringLiteral(">")));
        this.visitChildren(node);
        this.jsCodeBuilder.addChunksToOutputVar((List<? extends Expression>)ImmutableList.of((Object)Expression.stringLiteral("</velog>")));
    }

    @Override
    protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitJsImplNode(JsImplNode node) {
        Expression externReference;
        GoogRequire externRequire;
        ExternNode externNode = node.getParent();
        String externName = externNode.getIdentifier().originalName();
        if (this.topLevelSymbols.has(externName)) {
            return;
        }
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            externRequire = GoogRequire.createWithAlias(node.module(), node.module().replace('.', '$'));
            externReference = Expression.dottedIdNoRequire(externRequire.alias()).dotAccess(node.function());
        } else {
            externRequire = GoogRequire.create(node.module());
            externReference = JsRuntime.GOOG_MODULE_GET.call(Expression.stringLiteral(node.module())).dotAccess(node.function());
        }
        this.jsCodeBuilder.addGoogRequire(externRequire);
        this.topLevelSymbols.put(externName, externReference);
        if (externNode.isExported()) {
            SoyFileNode file = node.getNearestAncestor(SoyFileNode.class);
            Expression exportAlias = this.jsSrcOptions.shouldGenerateGoogModules() ? JsRuntime.EXPORTS : Expression.dottedIdNoRequire(file.getNamespace());
            Expression export = exportAlias.dotAccess(externName);
            Expression exportedReference = this.jsSrcOptions.shouldGenerateGoogModules() ? externReference : Expression.iife(externReference);
            this.jsCodeBuilder.append(Statement.assign(export, exportedReference));
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (!((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new UnsupportedOperationException("implement visit*Node for" + (Object)((Object)node.getKind()));
        }
        this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    private String genParamsRecordType(TemplateNode node) {
        HashSet<String> paramNames = new HashSet<String>();
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            JsType jsType = this.getJsTypeForParamForDeclaration(param.type());
            record.put(param.name(), jsType.typeExprForRecordMember(!param.isRequired()));
            for (GoogRequire require : jsType.getGoogRequires()) {
                this.jsCodeBuilder.addGoogRequire(require);
            }
            paramNames.add(param.name());
        }
        IndirectParamsCalculator.IndirectParamsInfo ipi = new IndirectParamsCalculator(this.fileSetMetadata).calculateIndirectParams(node);
        if (!ipi.mayHaveIndirectParamsInExternalCalls && !ipi.mayHaveIndirectParamsInExternalDelCalls) {
            for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                if (paramNames.contains(indirectParamName)) continue;
                ImmutableSet paramTypes = ipi.indirectParamTypes.get((Object)indirectParamName);
                SoyType combinedType = SoyTypes.computeLowestCommonType(this.typeRegistry, (Collection<SoyType>)paramTypes);
                SoyType indirectParamType = this.typeRegistry.getOrCreateUnionType(combinedType, NullType.getInstance());
                JsType jsType = this.getJsTypeForParamForDeclaration(indirectParamType);
                record.put(indirectParamName, jsType.typeExprForRecordMember(true));
            }
        }
        return JsType.toRecord(record);
    }

    protected final Statement genParamDefault(TemplateParam param, Expression paramTempVar, JsType typeForCast, CodeChunk.Generator codeGenerator) {
        Preconditions.checkArgument((boolean)param.hasDefault());
        return Statement.assign(paramTempVar, Expression.ifExpression(paramTempVar.tripleEquals(Expression.LITERAL_UNDEFINED), this.translateExpr(param.defaultValue())).setElse(paramTempVar).build(codeGenerator).castAs(typeForCast.typeExpr(), typeForCast.getGoogRequires()));
    }

    @CheckReturnValue
    protected Statement genParamTypeChecks(TemplateNode node, String alias, boolean isPositionalStyle) {
        ImmutableList.Builder declarations = ImmutableList.builder();
        for (TemplateParam param : node.getAllParams()) {
            String paramName = param.name();
            SoyType paramType = param.type();
            boolean isThisParamPositional = isPositionalStyle && !param.isInjected();
            CodeChunk.Generator generator = this.templateTranslationContext.codeGenerator();
            String paramAlias = this.genParamAlias(paramName);
            Expression paramChunk = isThisParamPositional ? Expression.id(paramAlias) : this.genCodeForParamAccess(paramName, param);
            JsType jsType = this.getJsTypeForParamTypeCheck(paramType);
            if (param.hasDefault()) {
                if (!isThisParamPositional) {
                    paramChunk = generator.declarationBuilder().setMutable().setRhs(paramChunk).build().ref();
                }
                declarations.add((Object)this.genParamDefault(param, paramChunk, jsType, generator));
            }
            Optional<Expression> soyTypeAssertion = jsType.getSoyParamTypeAssertion(paramChunk, paramName, param.isInjected() ? "@inject" : "@param", generator);
            if (isThisParamPositional) {
                if (soyTypeAssertion.isPresent()) {
                    declarations.add((Object)soyTypeAssertion.get().asStatement());
                }
            } else {
                VariableDeclaration.Builder declarationBuilder = VariableDeclaration.builder(paramAlias).setRhs(soyTypeAssertion.orElse(paramChunk)).setGoogRequires((Iterable<GoogRequire>)jsType.getGoogRequires());
                declarationBuilder.setJsDoc(JsDoc.builder().addParameterizedAnnotation("type", jsType.typeExpr()).build());
                VariableDeclaration declaration = declarationBuilder.build();
                declarations.add((Object)declaration);
            }
            this.templateTranslationContext.soyToJsVariableMappings().put(param, Expression.id(paramAlias));
        }
        return Statement.of((Iterable<Statement>)declarations.build());
    }

    protected JsType getJsTypeForParamForDeclaration(SoyType paramType) {
        return JsType.forJsSrc(paramType);
    }

    protected JsType getJsTypeForParamTypeCheck(SoyType paramType) {
        return this.getJsTypeForParamForDeclaration(paramType);
    }

    protected final String genParamAlias(String paramName) {
        return JsSrcUtils.isReservedWord(paramName) ? "param$" + paramName : paramName;
    }

    protected boolean isIncrementalDom() {
        return false;
    }

    private String namespaceForPath(SourceFilePath path) {
        return this.fileSetMetadata.getNamespaceForPath(path);
    }
}

