/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_FunctionDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Group;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Return;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.function.Consumer;

@AutoValue
abstract class FunctionDeclaration
extends Expression {
    FunctionDeclaration() {
    }

    abstract JsDoc jsDoc();

    abstract CodeChunk body();

    abstract boolean isArrowFunction();

    static FunctionDeclaration create(JsDoc jsDoc, Statement body) {
        return new AutoValue_FunctionDeclaration((ImmutableList<Statement>)ImmutableList.of(), jsDoc, body, false);
    }

    static FunctionDeclaration createArrowFunction(JsDoc jsDoc, Statement body) {
        return new AutoValue_FunctionDeclaration((ImmutableList<Statement>)ImmutableList.of(), jsDoc, body, true);
    }

    static FunctionDeclaration createArrowFunction(JsDoc jsDoc, Expression body) {
        return new AutoValue_FunctionDeclaration((ImmutableList<Statement>)ImmutableList.of(), jsDoc, body, true);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
    }

    @Override
    public void collectRequires(Consumer<GoogRequire> collector) {
        this.body().collectRequires(collector);
        this.jsDoc().collectRequires(collector);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        boolean paramsNeedParens;
        if (!this.isArrowFunction()) {
            ctx.append("function");
        }
        boolean bl = paramsNeedParens = !this.isArrowFunction() || this.jsDoc().params().size() != 1;
        if (paramsNeedParens) {
            ctx.append("(");
        }
        ctx.append(CodeChunkUtils.generateParamList(this.jsDoc(), this.isArrowFunction()));
        if (paramsNeedParens) {
            ctx.append(") ");
        }
        if (this.isArrowFunction()) {
            ctx.append(" => ");
        }
        if (this.isArrowFunction() && this.body() instanceof Expression) {
            Expression exprBody = (Expression)this.body();
            if (exprBody.isRepresentableAsSingleExpression()) {
                if (exprBody.initialExpressionIsObjectLiteral()) {
                    exprBody = Group.create(exprBody);
                }
                ctx.appendOutputExpression(exprBody);
            } else {
                try (FormattingContext ignored = ctx.enterBlock();){
                    ctx.appendAll(Return.create(exprBody));
                }
            }
        } else {
            try (FormattingContext ignored = ctx.enterBlock();){
                ctx.appendAll(this.body());
            }
        }
    }
}

