/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.jssrc.dsl.Conditional;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.IfThenPair;
import com.google.template.soy.jssrc.dsl.Statement;
import javax.annotation.Nullable;

public final class ConditionalBuilder {
    private final ImmutableList.Builder<IfThenPair<Statement>> conditions = ImmutableList.builder();
    @Nullable
    private Statement trailingElse = null;

    ConditionalBuilder(Expression predicate, Statement consequent) {
        this.conditions.add(new IfThenPair<Statement>(predicate, consequent));
    }

    public ConditionalBuilder addElseIf(Expression predicate, Statement consequent) {
        this.conditions.add(new IfThenPair<Statement>(predicate, consequent));
        return this;
    }

    public ConditionalBuilder setElse(Statement trailingElse) {
        Preconditions.checkState((this.trailingElse == null ? 1 : 0) != 0);
        this.trailingElse = trailingElse;
        return this;
    }

    @CheckReturnValue
    public Statement build() {
        return Conditional.create((ImmutableList<IfThenPair<Statement>>)this.conditions.build(), this.trailingElse);
    }
}

