/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.MissingPluginInstanceException;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.logging.LoggableElementMetadata;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.plugin.java.PluginInstances;
import com.google.template.soy.plugin.java.RenderCssHelper;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class RenderContext {
    private final Predicate<String> activeDelPackageSelector;
    private final CompiledTemplates templates;
    private final SoyCssRenamingMap cssRenamingMap;
    private final SoyIdRenamingMap xidRenamingMap;
    private final PluginInstances pluginInstances;
    private final ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap;
    private final SoyMsgBundle msgBundle;
    private final boolean debugSoyTemplateInfo;
    private final SoyLogger logger;
    private StackFrame topFrame = StackFrame.INIT;

    private static RenderResult emptyTemplate(SoyRecord params, SoyRecord ij, LoggingAdvisingAppendable appendable, RenderContext context) {
        return RenderResult.done();
    }

    private RenderContext(CompiledTemplates templates, ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap, PluginInstances pluginInstances, @Nullable Predicate<String> activeDelPackageSelector, @Nullable SoyCssRenamingMap cssRenamingMap, @Nullable SoyIdRenamingMap xidRenamingMap, @Nullable SoyMsgBundle msgBundle, boolean debugSoyTemplateInfo, @Nullable SoyLogger logger) {
        this.templates = templates;
        this.soyJavaDirectivesMap = soyJavaDirectivesMap;
        this.pluginInstances = pluginInstances;
        this.activeDelPackageSelector = activeDelPackageSelector != null ? activeDelPackageSelector : delPackage -> false;
        this.cssRenamingMap = cssRenamingMap == null ? SoyCssRenamingMap.EMPTY : cssRenamingMap;
        this.xidRenamingMap = xidRenamingMap == null ? SoyCssRenamingMap.EMPTY : xidRenamingMap;
        this.msgBundle = msgBundle == null ? SoyMsgBundle.EMPTY : msgBundle;
        this.debugSoyTemplateInfo = debugSoyTemplateInfo;
        this.logger = logger == null ? SoyLogger.NO_OP : logger;
    }

    @Nullable
    public ULocale getLocale() {
        return this.msgBundle.getLocale();
    }

    public RenderCssHelper getRenderCssHelper() {
        return (delTemplate, variant) -> {
            CompiledTemplates.TemplateData data = this.templates.selector.selectTemplate(delTemplate, variant, this.activeDelPackageSelector);
            return data != null ? data.soyTemplateName : null;
        };
    }

    public ImmutableList<String> getAllRequiredCssNamespaces(String template) {
        return this.templates.getAllRequiredCssNamespaces(template, this.activeDelPackageSelector, false);
    }

    public ImmutableList<String> getAllRequiredCssPaths(String template) {
        return this.templates.getAllRequiredCssPaths(template, this.activeDelPackageSelector, false);
    }

    public BidiGlobalDir getBidiGlobalDir() {
        return BidiGlobalDir.forStaticIsRtl(this.msgBundle.isRtl());
    }

    public Dir getBidiGlobalDirDir() {
        return this.getBidiGlobalDir().toDir();
    }

    public String renameCssSelector(String selector) {
        String string = this.cssRenamingMap.get(selector);
        return string == null ? selector : string;
    }

    public String renameXid(String id) {
        String string = this.xidRenamingMap.get(id);
        return string == null ? id + "_" : string;
    }

    public Object getPluginInstance(String name) {
        Supplier<Object> instanceSupplier = this.pluginInstances.get(name);
        if (instanceSupplier == null) {
            throw new MissingPluginInstanceException(name, String.format("No plugin instance registered for function with name '%s'.", name));
        }
        return instanceSupplier.get();
    }

    public SoyJavaPrintDirective getPrintDirective(String name) {
        SoyJavaPrintDirective printDirective = (SoyJavaPrintDirective)this.soyJavaDirectivesMap.get((Object)name);
        if (printDirective == null) {
            throw new IllegalStateException("Failed to find Soy print directive with name '" + name + "'");
        }
        return printDirective;
    }

    public Function<String, String> getEscapingDirectiveAsFunction(String name) {
        SoyJavaPrintDirective printDirective = (SoyJavaPrintDirective)this.soyJavaDirectivesMap.get((Object)name);
        if (printDirective == null) {
            throw new IllegalStateException("Failed to find Soy print directive with name '" + name + "'");
        }
        if (!printDirective.getValidArgsSizes().contains(0)) {
            throw new IllegalStateException("Soy print directive with name '" + name + "' is not an escaping directive");
        }
        return input -> printDirective.applyForJava(StringData.forValue(input), (List<SoyValue>)ImmutableList.of()).stringValue();
    }

    public boolean getDebugSoyTemplateInfo() {
        return this.debugSoyTemplateInfo;
    }

    public boolean hasLogger() {
        return this.logger != SoyLogger.NO_OP;
    }

    public SoyLogger getLogger() {
        return this.logger;
    }

    public CompiledTemplate getTemplate(String calleeName) {
        return this.templates.getTemplate(calleeName);
    }

    public CompiledTemplate getDelTemplate(String calleeName, String variant, boolean allowEmpty) {
        CompiledTemplate callee = this.templates.selectDelTemplate(calleeName, variant, this.activeDelPackageSelector);
        if (callee == null) {
            if (allowEmpty) {
                return RenderContext::emptyTemplate;
            }
            throw new IllegalArgumentException("Found no active impl for delegate call to \"" + calleeName + (variant.isEmpty() ? "" : ":" + variant) + "\" (and delcall does not set allowemptydefault=\"true\").");
        }
        return callee;
    }

    public boolean usePrimaryMsgIfFallback(long msgId, long fallbackId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty();
    }

    public boolean usePrimaryOrAlternateIfFallback(long msgId, long alternateId, long fallbackId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || !this.msgBundle.getMsgParts(alternateId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty();
    }

    public boolean usePrimaryIfFallbackOrFallbackAlternate(long msgId, long fallbackId, long fallbackAlternateId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty() && this.msgBundle.getMsgParts(fallbackAlternateId).isEmpty();
    }

    public boolean usePrimaryOrAlternateIfFallbackOrFallbackAlternate(long msgId, long alternateId, long fallbackId, long fallbackAlternateId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || !this.msgBundle.getMsgParts(alternateId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty() && this.msgBundle.getMsgParts(fallbackAlternateId).isEmpty();
    }

    public ImmutableList<SoyMsgPart> getSoyMsgParts(long msgId, ImmutableList<SoyMsgPart> defaultMsgParts) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            return defaultMsgParts;
        }
        return msgParts;
    }

    public ImmutableList<SoyMsgPart> getSoyMsgPartsWithAlternateId(long msgId, ImmutableList<SoyMsgPart> defaultMsgParts, long alternateId) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            ImmutableList<SoyMsgPart> msgPartsByAlternateId = this.msgBundle.getMsgParts(alternateId);
            if (msgPartsByAlternateId.isEmpty()) {
                return defaultMsgParts;
            }
            return msgPartsByAlternateId;
        }
        return msgParts;
    }

    public LoggableElementMetadata getVeMetadata(String metadataClassName, long veId) {
        try {
            return (LoggableElementMetadata)Class.forName(metadataClassName, true, this.templates.getClassLoader()).getMethod("getMetadata", Long.TYPE).invoke(null, veId);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void pushFrame(StackFrame state) {
        state.child = this.topFrame;
        this.topFrame = state;
    }

    public StackFrame popFrame() {
        StackFrame next = this.topFrame;
        this.topFrame = next.child;
        return next;
    }

    @VisibleForTesting
    public Builder toBuilder() {
        return new Builder(this.templates, this.soyJavaDirectivesMap, this.pluginInstances).withActiveDelPackageSelector(this.activeDelPackageSelector).withPluginInstances(this.pluginInstances).withCssRenamingMap(this.cssRenamingMap).withXidRenamingMap(this.xidRenamingMap).withMessageBundle(this.msgBundle);
    }

    public static final class Builder {
        private final CompiledTemplates templates;
        private final ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap;
        private PluginInstances pluginInstances;
        private Predicate<String> activeDelPackageSelector;
        private SoyCssRenamingMap cssRenamingMap;
        private SoyIdRenamingMap xidRenamingMap;
        private SoyMsgBundle msgBundle;
        private boolean debugSoyTemplateInfo;
        private SoyLogger logger;

        public Builder(CompiledTemplates templates, ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap, PluginInstances pluginInstances) {
            this.templates = templates;
            this.soyJavaDirectivesMap = soyJavaDirectivesMap;
            this.pluginInstances = pluginInstances;
        }

        public Builder withActiveDelPackageSelector(Predicate<String> activeDelPackageSelector) {
            this.activeDelPackageSelector = (Predicate)Preconditions.checkNotNull(activeDelPackageSelector);
            return this;
        }

        public Builder withCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.cssRenamingMap = (SoyCssRenamingMap)Preconditions.checkNotNull((Object)cssRenamingMap);
            return this;
        }

        public Builder withXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.xidRenamingMap = (SoyIdRenamingMap)Preconditions.checkNotNull((Object)xidRenamingMap);
            return this;
        }

        public Builder withPluginInstances(PluginInstances pluginInstances) {
            this.pluginInstances = (PluginInstances)Preconditions.checkNotNull((Object)pluginInstances);
            return this;
        }

        public Builder withMessageBundle(SoyMsgBundle msgBundle) {
            this.msgBundle = (SoyMsgBundle)Preconditions.checkNotNull((Object)msgBundle);
            return this;
        }

        public Builder withDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.debugSoyTemplateInfo = debugSoyTemplateInfo;
            return this;
        }

        public Builder withLogger(SoyLogger logger) {
            this.logger = logger;
            return this;
        }

        public RenderContext build() {
            return new RenderContext(this.templates, this.soyJavaDirectivesMap, this.pluginInstances, this.activeDelPackageSelector, this.cssRenamingMap, this.xidRenamingMap, this.msgBundle, this.debugSoyTemplateInfo, this.logger);
        }
    }
}

