/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValueProvider;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;

public final class RecordToPositionalCallFactory {
    private static final MethodType GET_FIELD_PROVIDER_TYPE = MethodType.methodType(SoyValueProvider.class, String.class);

    public static CallSite bootstrapDelegate(MethodHandles.Lookup lookup, String name, MethodType type, MethodHandle implMethod, String ... paramNames) {
        MethodHandle getFieldProvider = RecordToPositionalCallFactory.getFieldProviderHandle(lookup);
        MethodHandle[] argumentAdapters = (MethodHandle[])Arrays.stream(paramNames).map(paramName -> MethodHandles.insertArguments(getFieldProvider, 1, paramName)).toArray(MethodHandle[]::new);
        MethodHandle handle = MethodHandles.filterArguments(implMethod, 0, argumentAdapters);
        if (argumentAdapters.length == 0) {
            return new ConstantCallSite(MethodHandles.dropArguments(handle, 0, ImmutableList.of(SoyRecord.class)));
        }
        if (argumentAdapters.length == 1) {
            return new ConstantCallSite(handle);
        }
        int[] reorder = new int[handle.type().parameterCount()];
        int targetTypeArgument = 0;
        for (int i = paramNames.length - 1; i < handle.type().parameterCount(); ++i) {
            reorder[i] = targetTypeArgument++;
        }
        return new ConstantCallSite(MethodHandles.permuteArguments(handle, type, reorder));
    }

    private static MethodHandle getFieldProviderHandle(MethodHandles.Lookup lookup) {
        try {
            return lookup.findVirtual(SoyRecord.class, "getFieldProvider", GET_FIELD_PROVIDER_TYPE);
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError((Object)roe);
        }
    }

    private RecordToPositionalCallFactory() {
    }
}

