/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.restricted.AutoValue_TypeInfo;
import java.util.Optional;
import org.objectweb.asm.Type;

@AutoValue
public abstract class TypeInfo {
    public static TypeInfo create(Class<?> clazz) {
        Type type = Type.getType(clazz);
        return new AutoValue_TypeInfo(clazz.getName(), clazz.getSimpleName(), type.getInternalName(), type, clazz.isInterface(), Optional.of(clazz));
    }

    public static TypeInfo create(String className, boolean isInterface) {
        Type type = Type.getObjectType((String)className.replace('.', '/'));
        String packageLessName = className.substring(className.lastIndexOf(46) + 1);
        String simpleName = packageLessName.substring(packageLessName.lastIndexOf(36) + 1);
        return new AutoValue_TypeInfo(className, simpleName, type.getInternalName(), type, isInterface, Optional.empty());
    }

    public static TypeInfo createClass(String className) {
        return TypeInfo.create(className, false);
    }

    public static TypeInfo createInterface(String className) {
        return TypeInfo.create(className, true);
    }

    public abstract String className();

    public abstract String simpleName();

    public abstract String internalName();

    public abstract Type type();

    public abstract boolean isInterface();

    public abstract Optional<Class<?>> classOptional();

    public final TypeInfo innerClass(String simpleName) {
        Preconditions.checkArgument((simpleName.indexOf(36) == -1 ? 1 : 0) != 0, (String)"Simple names shouldn't contain '$': %s", (Object)simpleName);
        String className = this.className() + '$' + simpleName;
        String internalName = this.internalName() + '$' + simpleName;
        Type type = Type.getObjectType((String)internalName);
        return new AutoValue_TypeInfo(className, simpleName, internalName, type, false, Optional.empty());
    }
}

