/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.restricted.BytecodeProducer;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import java.io.IOException;
import java.util.Arrays;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public abstract class Statement
extends BytecodeProducer {
    private static final Type[] IO_EXCEPTION_ARRAY = new Type[]{Type.getType(IOException.class)};
    public static final Statement NULL_STATEMENT = new Statement(){

        @Override
        protected void doGen(CodeBuilder adapter) {
        }
    };
    public static final Statement RETURN = new Statement(){

        @Override
        protected void doGen(CodeBuilder adapter) {
            adapter.returnValue();
        }
    };

    public static Statement returnExpression(final Expression expression) {
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                expression.gen(adapter);
                adapter.returnValue();
            }
        };
    }

    public static Statement throwExpression(final Expression expression) {
        expression.checkAssignableTo(BytecodeUtils.THROWABLE_TYPE);
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                expression.gen(adapter);
                adapter.throwException();
            }
        };
    }

    public static Statement concat(Statement ... statements) {
        return Statement.concat(Arrays.asList(statements));
    }

    public static Statement concat(final Iterable<? extends Statement> statements) {
        Preconditions.checkNotNull(statements);
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                for (Statement statement : statements) {
                    statement.gen(adapter);
                }
            }
        };
    }

    protected Statement() {
    }

    protected Statement(SourceLocation location) {
        super(location);
    }

    public final void writeMethod(int access, Method method, ClassVisitor visitor) {
        this.writeMethodTo(new CodeBuilder(access, method, null, visitor));
    }

    public final void writeIOExceptionMethod(int access, Method method, ClassVisitor visitor) {
        this.writeMethodTo(new CodeBuilder(access, method, IO_EXCEPTION_ARRAY, visitor));
    }

    public final void writeMethodTo(CodeBuilder builder) {
        try {
            builder.visitCode();
            this.gen(builder);
            builder.endMethod();
        }
        catch (Throwable t) {
            String serialized = null;
            try {
                serialized = String.valueOf(this);
                throw new RuntimeException("Failed to generate method:\n" + serialized, t);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate method (and error during serialization = " + e + ")", t);
            }
        }
    }

    public final Statement labelStart(final Label label) {
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(label);
                Statement.this.gen(adapter);
            }
        };
    }

    public final Statement labelEnd(final Label label) {
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Statement.this.gen(adapter);
                adapter.mark(label);
            }
        };
    }

    public final Statement withSourceLocation(SourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        if (location.equals(this.location)) {
            return this;
        }
        return new Statement(location){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Statement.this.gen(adapter);
            }
        };
    }

    public final Expression then(final Expression expression) {
        return new Expression(expression.resultType(), expression.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Statement.this.gen(adapter);
                expression.gen(adapter);
            }
        };
    }

    public String toString() {
        return "Statement:\n" + this.trace();
    }
}

