/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import java.util.Optional;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class LocalVariable
extends Expression {
    private final String variableName;
    private final int index;
    private final Label start;
    private final Label end;

    public static LocalVariable createThisVar(TypeInfo owner, Label start, Label end) {
        return new LocalVariable("this", owner.type(), 0, start, end, Expression.Feature.NON_NULLABLE);
    }

    public static LocalVariable createLocal(String name, int index, Type type, Label start, Label end) {
        return new LocalVariable(name, type, index, start, end, new Expression.Feature[0]);
    }

    private LocalVariable(String variableName, Type type, int index, Label start, Label end, Expression.Feature ... features) {
        super(type, Expression.Feature.CHEAP, features);
        this.variableName = (String)Preconditions.checkNotNull((Object)variableName);
        this.index = index;
        this.start = (Label)Preconditions.checkNotNull((Object)start);
        this.end = (Label)Preconditions.checkNotNull((Object)end);
    }

    public String variableName() {
        return this.variableName;
    }

    public int index() {
        return this.index;
    }

    public Label start() {
        return this.start;
    }

    public Label end() {
        return this.end;
    }

    @Override
    public LocalVariable asCheap() {
        return this;
    }

    @Override
    public LocalVariable asNonNullable() {
        if (this.isNonNullable()) {
            return this;
        }
        return new LocalVariable(this.variableName, this.resultType(), this.index, this.start, this.end, Expression.Feature.NON_NULLABLE);
    }

    public void tableEntry(CodeBuilder mv) {
        mv.visitLocalVariable(this.variableName(), this.resultType().getDescriptor(), null, this.start(), this.end(), this.index());
    }

    @Override
    protected void doGen(CodeBuilder mv) {
        mv.visitVarInsn(this.resultType().getOpcode(21), this.index());
    }

    public Statement store(Expression expr) {
        return this.store(expr, Optional.empty());
    }

    public Statement store(Expression expr, Label firstVarInstruction) {
        return this.store(expr, Optional.of(firstVarInstruction));
    }

    private Statement store(final Expression expr, final Optional<Label> firstVarInstruction) {
        expr.checkAssignableTo(this.resultType());
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                expr.gen(adapter);
                if (firstVarInstruction.isPresent()) {
                    adapter.mark((Label)firstVarInstruction.get());
                }
                adapter.visitVarInsn(LocalVariable.this.resultType().getOpcode(54), LocalVariable.this.index());
            }
        };
    }

    @Override
    protected void extraToStringProperties(MoreObjects.ToStringHelper helper) {
        helper.add("name", (Object)this.variableName);
    }
}

