/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.internal.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class SimpleLocalVariableManager
implements LocalVariableManager {
    private final UniqueNameGenerator localNames = JbcSrcNameGenerators.forFieldNames();
    private final List<LocalVariable> allVariables = new ArrayList<LocalVariable>();
    private final BitSet availableSlots = new BitSet();
    private final Map<String, LocalVariable> activeVariables = new LinkedHashMap<String, LocalVariable>();
    private boolean generated;

    SimpleLocalVariableManager(Type ownerType, Method method, boolean isStatic) {
        this(ownerType, method, (ImmutableList<String>)ImmutableList.of(), null, null, isStatic);
    }

    SimpleLocalVariableManager(Type ownerType, Method method, ImmutableList<String> parameterNames, Label methodBegin, Label methodEnd, boolean isStatic) {
        Type[] argumentTypes = method.getArgumentTypes();
        Preconditions.checkArgument((argumentTypes.length == parameterNames.size() ? 1 : 0) != 0, (String)"expected %s args, got %s paramNames: %s", (Object)argumentTypes.length, (Object)parameterNames.size(), parameterNames);
        if (!isStatic) {
            this.reserveParameter("this", ownerType, methodBegin, methodEnd);
        }
        int parameterIndex = 0;
        for (Type type : argumentTypes) {
            this.reserveParameter((String)parameterNames.get(parameterIndex), type, methodBegin, methodEnd);
            ++parameterIndex;
        }
    }

    private void reserveParameter(String name, Type type, Label methodBegin, Label methodEnd) {
        int slot = this.reserveSlotFor(type);
        this.localNames.claimName(name);
        LocalVariable var = LocalVariable.createLocal(name, slot, type, methodBegin, methodEnd);
        this.allVariables.add(var);
        this.activeVariables.put(name, var);
    }

    @Override
    public Expression getVariable(String name) {
        LocalVariable var = this.activeVariables.get(name);
        if (var == null) {
            throw new IllegalArgumentException("Can't find variable: " + name + " among the active variables: " + this.activeVariables.keySet());
        }
        return var;
    }

    ImmutableMap<String, LocalVariable> allActiveVariables() {
        return ImmutableMap.copyOf(this.activeVariables);
    }

    LocalVariable unsafeBorrowSlot(String name, Type type) {
        int slot = this.reserveSlotFor(type);
        LocalVariable var = LocalVariable.createLocal(name, slot, type, new Label(), new Label());
        this.returnSlotFor(var);
        return var;
    }

    @Override
    public void generateTableEntries(CodeBuilder cb) {
        this.generated = true;
        for (LocalVariable var : this.allVariables) {
            try {
                var.tableEntry(cb);
            }
            catch (Throwable t) {
                throw new RuntimeException("unable to write table entry for: " + var, t);
            }
        }
    }

    @Override
    public LocalVariableManager.Scope enterScope() {
        Preconditions.checkState((!this.generated ? 1 : 0) != 0);
        final ArrayList frame = new ArrayList();
        return new LocalVariableManager.Scope(){
            final Label scopeExit = new Label();
            boolean exited;

            @Override
            public LocalVariable createNamedLocal(String name, Type type) {
                LocalVariable var = this.createTemporary(name, type);
                SimpleLocalVariableManager.this.activeVariables.put(name, var);
                return var;
            }

            @Override
            public LocalVariable createTemporary(String proposedName, Type type) {
                Preconditions.checkState((!SimpleLocalVariableManager.this.generated ? 1 : 0) != 0);
                Preconditions.checkState((!this.exited ? 1 : 0) != 0);
                String name = SimpleLocalVariableManager.this.localNames.generateName(proposedName);
                int slot = SimpleLocalVariableManager.this.reserveSlotFor(type);
                LocalVariable var = LocalVariable.createLocal(name, slot, type, new Label(), this.scopeExit);
                frame.add(var);
                return var;
            }

            @Override
            public Statement exitScope() {
                Preconditions.checkState((!SimpleLocalVariableManager.this.generated ? 1 : 0) != 0);
                Preconditions.checkState((!this.exited ? 1 : 0) != 0);
                this.exited = true;
                for (LocalVariable var : frame) {
                    SimpleLocalVariableManager.this.returnSlotFor(var);
                    SimpleLocalVariableManager.this.activeVariables.remove(var.variableName());
                }
                return new Statement(){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        adapter.mark(scopeExit);
                    }
                };
            }
        };
    }

    private void returnSlotFor(LocalVariable var) {
        this.availableSlots.clear(var.index(), var.index() + var.resultType().getSize());
    }

    private int reserveSlotFor(Type type) {
        int size = type.getSize();
        Preconditions.checkArgument((size == 1 || size == 2 ? 1 : 0) != 0);
        int start = 0;
        while (start < 65536) {
            int nextClear = this.availableSlots.nextClearBit(start);
            if (size == 1 || size == 2 && !this.availableSlots.get(nextClear + 1)) {
                this.availableSlots.set(nextClear, nextClear + size);
                return nextClear;
            }
            start = nextClear + 1;
        }
        throw new RuntimeException("too many local variables");
    }
}

