/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_LazyClosureCompiler_LazyClosure;
import com.google.template.soy.jbcsrc.AutoValue_LazyClosureCompiler_ParentCapture;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.ExpressionToSoyValueProviderCompiler;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SimpleLocalVariableManager;
import com.google.template.soy.jbcsrc.SoyNodeCompiler;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.DetachableContentProvider;
import com.google.template.soy.jbcsrc.runtime.DetachableSoyValueProvider;
import com.google.template.soy.jbcsrc.runtime.DetachableSoyValueProviderProvider;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class LazyClosureCompiler {
    private static final int LAZY_CLOSURE_ACCESS = 16;
    private static final Method DO_RESOLVE;
    private static final Method DO_RESOLVE_DELEGATE;
    private static final Method DO_RENDER;
    private static final FieldRef RESOLVED_VALUE;
    private static final FieldRef RESOLVED_VALUE_PROVIDER;
    private static final TypeInfo DETACHABLE_CONTENT_PROVIDER_TYPE;
    private static final TypeInfo DETACHABLE_VALUE_PROVIDER_TYPE;
    private static final TypeInfo DETACHABLE_VALUE_PROVIDER_PROVIDER_TYPE;
    private final SoyNodeCompiler parent;

    LazyClosureCompiler(SoyNodeCompiler parent) {
        this.parent = parent;
    }

    private boolean requiresDetachLogic(SoyNode.RenderUnitNode root) {
        Preconditions.checkState((!(root instanceof TemplateNode) ? 1 : 0) != 0);
        return SoyTreeUtils.allNodes(root, n -> n instanceof ExprNode ? SoyTreeUtils.VisitDirective.SKIP_CHILDREN : SoyTreeUtils.VisitDirective.CONTINUE).anyMatch(node -> {
            if (node instanceof ExprNode) {
                return ExpressionCompiler.requiresDetach(this.parent.analysis, (ExprNode)node);
            }
            return node instanceof CallNode;
        });
    }

    LazyClosure compileLazyExpression(String namePrefix, SoyNode declaringNode, String varName, ExprRootNode exprNode) {
        if (ExpressionCompiler.canCompileToConstant(exprNode)) {
            SoyExpression expression = this.parent.constantCompiler.compile(exprNode);
            return LazyClosure.create(varName, this.parent.fields.addStaticField(this.getProposedName(namePrefix, varName), expression.boxAsSoyValueProvider()).accessor(), true, false);
        }
        Optional<Expression> asSoyValueProvider = this.parent.expressionToSoyValueProviderCompiler.compileAvoidingDetaches(exprNode);
        if (asSoyValueProvider.isPresent()) {
            Expression svp = asSoyValueProvider.get();
            return LazyClosure.create(varName, svp, exprNode.getRoot().getKind() == ExprNode.Kind.VAR_REF_NODE, ExpressionCompiler.requiresDetach(this.parent.analysis, exprNode));
        }
        TypeInfo type = this.parent.innerClasses.registerInnerClassWithGeneratedName(this.getProposedName(namePrefix, varName), 16);
        SoyClassWriter writer = SoyClassWriter.builder(type).setAccess(16).extending(DETACHABLE_VALUE_PROVIDER_PROVIDER_TYPE).sourceFileName(declaringNode.getSourceLocation().getFileName()).build();
        Optional<Expression> asSoyValueProviderProvider = new CompilationUnit(this.parent.analysis, writer, type, DETACHABLE_VALUE_PROVIDER_PROVIDER_TYPE, declaringNode).compileExpressionToSoyValueProviderIfUseful(exprNode);
        if (asSoyValueProviderProvider.isPresent()) {
            this.parent.innerClasses.registerAsInnerClass(writer, type);
            writer.visitEnd();
            this.parent.innerClasses.add(writer.toClassData());
            return LazyClosure.create(varName, asSoyValueProviderProvider.get(), false, true);
        }
        writer = SoyClassWriter.builder(type).setAccess(16).extending(DETACHABLE_VALUE_PROVIDER_TYPE).sourceFileName(declaringNode.getSourceLocation().getFileName()).build();
        Expression expr = new CompilationUnit(this.parent.analysis, writer, type, DETACHABLE_VALUE_PROVIDER_TYPE, declaringNode).compileExpression(exprNode);
        this.parent.innerClasses.registerAsInnerClass(writer, type);
        writer.visitEnd();
        this.parent.innerClasses.add(writer.toClassData());
        return LazyClosure.create(varName, expr, false, true);
    }

    LazyClosure compileLazyContent(String namePrefix, SoyNode.RenderUnitNode renderUnit, String varName) {
        return this.compileLazyContent(namePrefix, renderUnit, varName, ExtraCodeCompiler.NO_OP, ExtraCodeCompiler.NO_OP);
    }

    LazyClosure compileLazyContent(String namePrefix, SoyNode.RenderUnitNode renderUnit, String varName, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        Optional asRawText;
        String proposedName = this.getProposedName(namePrefix, varName);
        Optional<Object> optional = asRawText = prefix == ExtraCodeCompiler.NO_OP && suffix == ExtraCodeCompiler.NO_OP ? this.asRawTextOnly(proposedName, renderUnit) : Optional.empty();
        if (asRawText.isPresent()) {
            return LazyClosure.create(varName, (Expression)asRawText.get(), true, false);
        }
        if (!(prefix.requiresDetachLogic(this.parent.analysis) || suffix.requiresDetachLogic(this.parent.analysis) || this.requiresDetachLogic(renderUnit))) {
            return LazyClosure.create(varName, this.renderIntoBuffer(renderUnit, prefix, suffix), false, false);
        }
        TypeInfo type = this.parent.innerClasses.registerInnerClassWithGeneratedName(proposedName, 16);
        SoyClassWriter writer = SoyClassWriter.builder(type).setAccess(16).extending(DETACHABLE_CONTENT_PROVIDER_TYPE).sourceFileName(renderUnit.getSourceLocation().getFileName()).build();
        Expression expr = new CompilationUnit(this.parent.analysis, writer, type, DETACHABLE_CONTENT_PROVIDER_TYPE, renderUnit).compileRenderable(renderUnit, prefix, suffix);
        this.parent.innerClasses.registerAsInnerClass(writer, type);
        writer.visitEnd();
        this.parent.innerClasses.add(writer.toClassData());
        return LazyClosure.create(varName, expr, false, true);
    }

    private Expression renderIntoBuffer(SoyNode.RenderUnitNode renderUnitNode, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        TemplateVariableManager.Scope scope = this.parent.variables.enterScope();
        LocalVariable variable = scope.createTemporary("buffer", MethodRef.LOGGING_ADVISING_APPENDABLE_BUFFERING.returnType()).asNonNullable();
        Statement initBuffer = variable.store(MethodRef.LOGGING_ADVISING_APPENDABLE_BUFFERING.invoke(new Expression[0]));
        Statement populateBuffer = this.parent.compilerWithNewAppendable(AppendableExpression.forExpression(variable)).compileWithoutDetaches(renderUnitNode, prefix, suffix);
        return Statement.concat(initBuffer.labelStart(variable.start()), populateBuffer, scope.exitScope()).then(MethodRef.BUFFERED_SOY_VALUE_PROVIDER_CREATE.invoke(variable));
    }

    private Optional<Expression> asRawTextOnly(String name, SoyNode.RenderUnitNode renderUnit) {
        StringBuilder builder = null;
        ArrayList children = new ArrayList(renderUnit.getChildren());
        for (int i = 0; i < children.size(); ++i) {
            SoyNode child = (SoyNode)children.get(i);
            if (child instanceof MsgHtmlTagNode) {
                children.addAll(i + 1, ((MsgHtmlTagNode)child).getChildren());
                continue;
            }
            if (child instanceof RawTextNode) {
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(((RawTextNode)child).getRawText());
                continue;
            }
            return Optional.empty();
        }
        Expression value = BytecodeUtils.constant(builder == null ? "" : builder.toString());
        SanitizedContentKind kind = renderUnit.getContentKind();
        value = kind == SanitizedContentKind.TEXT ? MethodRef.STRING_DATA_FOR_VALUE.invoke(value) : MethodRef.ORDAIN_AS_SAFE.invoke(value, BytecodeUtils.constantSanitizedContentKindAsContentKind(kind));
        FieldRef staticField = this.parent.fields.addStaticField(name, value);
        return Optional.of(staticField.accessor());
    }

    private String getProposedName(String prefix, String varName) {
        return prefix + "_" + varName;
    }

    static {
        RESOLVED_VALUE = FieldRef.instanceFieldReference(DetachableSoyValueProvider.class, "resolvedValue");
        RESOLVED_VALUE_PROVIDER = FieldRef.instanceFieldReference(DetachableSoyValueProviderProvider.class, "resolvedValueProvider");
        DETACHABLE_CONTENT_PROVIDER_TYPE = TypeInfo.create(DetachableContentProvider.class);
        DETACHABLE_VALUE_PROVIDER_TYPE = TypeInfo.create(DetachableSoyValueProvider.class);
        DETACHABLE_VALUE_PROVIDER_PROVIDER_TYPE = TypeInfo.create(DetachableSoyValueProviderProvider.class);
        try {
            DO_RESOLVE = Method.getMethod((java.lang.reflect.Method)DetachableSoyValueProvider.class.getDeclaredMethod("doResolve", new Class[0]));
            DO_RESOLVE_DELEGATE = Method.getMethod((java.lang.reflect.Method)DetachableSoyValueProviderProvider.class.getDeclaredMethod("doResolveDelegate", new Class[0]));
            DO_RENDER = Method.getMethod((java.lang.reflect.Method)DetachableContentProvider.class.getDeclaredMethod("doRender", LoggingAdvisingAppendable.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class LazyClosureParameterLookup
    implements TemplateParameterLookup {
        private final CompilationUnit params;
        private final TemplateParameterLookup parentParameterLookup;
        private final TemplateVariableManager variableSet;
        private final Expression thisVar;
        private final Map<VarDefn, ParentCapture> localFields = new LinkedHashMap<VarDefn, ParentCapture>();
        private final Map<SyntheticVarName, ParentCapture> syntheticFields = new LinkedHashMap<SyntheticVarName, ParentCapture>();
        private ParentCapture renderContextCapture;
        private ParentCapture ijCapture;
        private ParentCapture paramsCapture;

        LazyClosureParameterLookup(CompilationUnit params, TemplateParameterLookup parentParameterLookup, TemplateVariableManager variableSet, Expression thisVar) {
            this.params = params;
            this.parentParameterLookup = parentParameterLookup;
            this.variableSet = variableSet;
            this.thisVar = thisVar;
        }

        @Override
        public Expression getParam(TemplateParam param) {
            ParentCapture capturedField = this.localFields.get(param);
            if (capturedField == null) {
                Expression expression = this.parentParameterLookup.getParam(param);
                FieldRef field = this.params.fields.addGeneratedFinalField(param.name(), expression.resultType());
                capturedField = ParentCapture.create(field, expression);
                this.localFields.put(param, capturedField);
            }
            return capturedField.field().accessor(this.thisVar);
        }

        @Override
        public Expression getIjRecord() {
            if (this.ijCapture == null) {
                this.ijCapture = ParentCapture.create(this.params.fields.addFinalField("$ij", BytecodeUtils.SOY_RECORD_TYPE), this.parentParameterLookup.getIjRecord());
            }
            return this.ijCapture.field().accessor(this.thisVar);
        }

        @Override
        public Expression getParamsRecord() {
            if (this.paramsCapture == null) {
                this.paramsCapture = ParentCapture.create(this.params.fields.addFinalField("$params", BytecodeUtils.SOY_RECORD_TYPE), this.parentParameterLookup.getParamsRecord());
            }
            return this.paramsCapture.field().accessor(this.thisVar);
        }

        @Override
        public Expression getLocal(AbstractLocalVarDefn<?> local) {
            if (SoyTreeUtils.isDescendantOf(local.declaringNode(), (Node)this.params.node)) {
                return this.variableSet.getVariable(local.name());
            }
            ParentCapture capturedField = this.localFields.get(local);
            if (capturedField == null) {
                Expression expression = this.parentParameterLookup.getLocal(local);
                FieldRef field = this.params.fields.addGeneratedFinalField(local.name(), expression.resultType());
                capturedField = ParentCapture.create(field, expression);
                this.localFields.put(local, capturedField);
            }
            return capturedField.field().accessor(this.thisVar);
        }

        @Override
        public Expression getLocal(SyntheticVarName varName) {
            if (SoyTreeUtils.isDescendantOf(varName.declaringNode(), (Node)this.params.node)) {
                return this.variableSet.getVariable(varName);
            }
            ParentCapture capturedField = this.syntheticFields.get(varName);
            if (capturedField == null) {
                Expression expression = this.parentParameterLookup.getLocal(varName);
                FieldRef field = this.params.fields.addGeneratedFinalField(varName.name(), expression.resultType());
                capturedField = ParentCapture.create(field, expression);
                this.syntheticFields.put(varName, capturedField);
            }
            return capturedField.field().accessor(this.thisVar);
        }

        Iterable<ParentCapture> getCapturedFields() {
            return Iterables.concat((Iterable)Iterables.filter(Arrays.asList(this.renderContextCapture, this.ijCapture, this.paramsCapture), Objects::nonNull), this.localFields.values(), this.syntheticFields.values());
        }

        @Override
        public RenderContextExpression getRenderContext() {
            if (this.renderContextCapture == null) {
                this.renderContextCapture = ParentCapture.create(this.params.fields.addFinalField("$renderContext", BytecodeUtils.RENDER_CONTEXT_TYPE), this.parentParameterLookup.getRenderContext());
            }
            return new RenderContextExpression(this.renderContextCapture.field().accessor(this.thisVar));
        }
    }

    @AutoValue
    static abstract class ParentCapture {
        ParentCapture() {
        }

        static ParentCapture create(FieldRef captureField, Expression parentExpression) {
            if (parentExpression.isNonNullable()) {
                captureField = captureField.asNonNull();
            }
            return new AutoValue_LazyClosureCompiler_ParentCapture(captureField, parentExpression);
        }

        abstract FieldRef field();

        abstract Expression parentExpression();
    }

    private final class CompilationUnit {
        final TemplateAnalysis analysis;
        final FieldManager fields;
        final TypeInfo type;
        final TypeInfo baseClass;
        final SoyNode node;
        final SoyClassWriter writer;

        CompilationUnit(TemplateAnalysis analysis, SoyClassWriter writer, TypeInfo type, TypeInfo baseClass, SoyNode node) {
            this.analysis = analysis;
            this.writer = writer;
            this.fields = new FieldManager(type);
            this.type = type;
            this.baseClass = baseClass;
            this.node = node;
        }

        Expression compileExpression(ExprNode exprNode) {
            final Label start = new Label();
            final Label end = new Label();
            final TemplateVariableManager variableSet = new TemplateVariableManager(this.type.type(), DO_RESOLVE, (ImmutableList<String>)ImmutableList.of(), start, end, false);
            Expression thisVar = variableSet.getVariable("this");
            LazyClosureParameterLookup lookup = new LazyClosureParameterLookup(this, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.parameterLookup, variableSet, thisVar);
            SoyExpression compile = ExpressionCompiler.createBasicCompiler(this.node, this.analysis, lookup, variableSet, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.javaSourceFunctionCompiler, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.fileSetMetadata).compile(exprNode);
            SoyExpression expression = compile.box();
            final Statement storeExpr = RESOLVED_VALUE.putInstanceField(thisVar, expression);
            final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
            Statement doResolveImpl = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.mark(start);
                    storeExpr.gen(adapter);
                    returnDone.gen(adapter);
                    adapter.mark(end);
                    variableSet.generateTableEntries(adapter);
                }
            };
            Expression constructExpr = this.generateConstructor(lookup.getCapturedFields());
            doResolveImpl.writeMethod(4, DO_RESOLVE, this.writer);
            this.fields.defineFields(this.writer);
            this.fields.defineStaticInitializer(this.writer);
            return constructExpr;
        }

        Optional<Expression> compileExpressionToSoyValueProviderIfUseful(ExprNode exprNode) {
            Expression thisVar;
            final Label start = new Label();
            final Label end = new Label();
            final TemplateVariableManager variableSet = new TemplateVariableManager(this.type.type(), DO_RESOLVE_DELEGATE, (ImmutableList<String>)ImmutableList.of(), start, end, false);
            LazyClosureParameterLookup lookup = new LazyClosureParameterLookup(this, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.parameterLookup, variableSet, thisVar = variableSet.getVariable("this"));
            ExpressionCompiler expressionCompiler = ExpressionCompiler.create(this.node, this.analysis, lookup, variableSet, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.javaSourceFunctionCompiler, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.fileSetMetadata);
            Optional<Expression> expr = ExpressionToSoyValueProviderCompiler.create(this.analysis, expressionCompiler, lookup).compileToSoyValueProviderIfUsefulToPreserveStreaming(exprNode, ExpressionDetacher.BasicDetacher.INSTANCE);
            if (!expr.isPresent()) {
                return Optional.empty();
            }
            final Statement storeExpr = RESOLVED_VALUE_PROVIDER.putInstanceField(thisVar, expr.get());
            final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
            Statement doResolveImpl = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.mark(start);
                    storeExpr.gen(adapter);
                    returnDone.gen(adapter);
                    adapter.mark(end);
                    variableSet.generateTableEntries(adapter);
                }
            };
            Expression constructExpr = this.generateConstructor(lookup.getCapturedFields());
            doResolveImpl.writeMethod(4, DO_RESOLVE_DELEGATE, this.writer);
            this.fields.defineFields(this.writer);
            this.fields.defineStaticInitializer(this.writer);
            return Optional.of(constructExpr);
        }

        Expression compileRenderable(SoyNode.RenderUnitNode renderUnit, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
            final Label start = new Label();
            final Label end = new Label();
            ExpressionCompiler.BasicExpressionCompiler constantCompiler = ExpressionCompiler.createConstantCompiler(this.node, this.analysis, new SimpleLocalVariableManager(this.type.type(), BytecodeUtils.CLASS_INIT, true), ((LazyClosureCompiler)LazyClosureCompiler.this).parent.javaSourceFunctionCompiler, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.fileSetMetadata);
            final TemplateVariableManager variableSet = new TemplateVariableManager(this.type.type(), DO_RENDER, (ImmutableList<String>)ImmutableList.of((Object)"$appendable"), start, end, false);
            LazyClosureParameterLookup lookup = new LazyClosureParameterLookup(this, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.parameterLookup, variableSet, variableSet.getVariable("this"));
            SoyNodeCompiler soyNodeCompiler = SoyNodeCompiler.create(this.node, this.analysis, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.innerClasses, AppendableExpression.forExpression(variableSet.getVariable("$appendable").asNonNullable()), variableSet, lookup, this.fields, constantCompiler, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.javaSourceFunctionCompiler, ((LazyClosureCompiler)LazyClosureCompiler.this).parent.fileSetMetadata);
            SoyNodeCompiler.CompiledMethodBody compileChildren = soyNodeCompiler.compile(renderUnit, prefix, suffix);
            this.writer.setNumDetachStates(compileChildren.numberOfDetachStates());
            final Statement nodeBody = compileChildren.body();
            final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
            Statement fullMethodBody = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.mark(start);
                    nodeBody.gen(adapter);
                    adapter.mark(end);
                    returnDone.gen(adapter);
                    variableSet.generateTableEntries(adapter);
                }
            };
            Expression constructExpr = this.generateConstructor(lookup.getCapturedFields());
            this.fields.defineFields(this.writer);
            fullMethodBody.writeMethod(4, DO_RENDER, this.writer);
            this.fields.defineStaticInitializer(this.writer);
            return constructExpr;
        }

        Expression generateConstructor(Iterable<ParentCapture> captures) {
            final Label start = new Label();
            final Label end = new Label();
            final LocalVariable thisVar = LocalVariable.createThisVar(this.type, start, end);
            final ArrayList<LocalVariable> params = new ArrayList<LocalVariable>();
            ArrayList<Type> paramTypes = new ArrayList<Type>();
            final ArrayList<Statement> assignments = new ArrayList<Statement>();
            ArrayList<Expression> argExpressions = new ArrayList<Expression>();
            int index = 1;
            for (ParentCapture capture : captures) {
                FieldRef field = capture.field();
                LocalVariable var = LocalVariable.createLocal(field.name(), index, field.type(), start, end);
                assignments.add(field.putInstanceField(thisVar, var));
                argExpressions.add(capture.parentExpression());
                params.add(var);
                paramTypes.add(field.type());
                index += field.type().getSize();
            }
            Statement constructorBody = new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    cb.mark(start);
                    cb.loadThis();
                    cb.invokeConstructor(CompilationUnit.this.baseClass.type(), BytecodeUtils.NULLARY_INIT);
                    for (Statement assignment : assignments) {
                        assignment.gen(cb);
                    }
                    cb.returnValue();
                    cb.mark(end);
                    thisVar.tableEntry(cb);
                    for (LocalVariable local : params) {
                        local.tableEntry(cb);
                    }
                }
            };
            ConstructorRef constructor = ConstructorRef.create(this.type, paramTypes);
            constructorBody.writeMethod(1, constructor.method(), this.writer);
            return constructor.construct(argExpressions);
        }
    }

    @AutoValue
    static abstract class LazyClosure {
        LazyClosure() {
        }

        static LazyClosure create(String name, Expression soyValueProvider, boolean isTrivial, boolean requiresDetachLogicToResolve) {
            soyValueProvider.checkAssignableTo(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            return new AutoValue_LazyClosureCompiler_LazyClosure(name, soyValueProvider, isTrivial, requiresDetachLogicToResolve);
        }

        abstract String name();

        abstract Expression soyValueProvider();

        abstract boolean isTrivial();

        abstract boolean requiresDetachLogicToResolve();
    }
}

