/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.JbcSrcValueFactory;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.plugin.internal.JavaPluginExecContext;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.List;
import javax.annotation.Nullable;

final class JavaSourceFunctionCompiler {
    private final SoyTypeRegistry typeRegistry;
    private final ErrorReporter errorReporter;

    JavaSourceFunctionCompiler(SoyTypeRegistry typeRegistry, ErrorReporter errorReporter) {
        this.typeRegistry = typeRegistry;
        this.errorReporter = errorReporter;
    }

    SoyExpression compile(MethodCallNode node, SoySourceFunctionMethod method, List<SoyExpression> args, @Nullable TemplateParameterLookup parameters, ExpressionDetacher detacher) {
        return this.compile(JavaPluginExecContext.forMethodCallNode(node, method), args, parameters, detacher);
    }

    SoyExpression compile(FunctionNode node, SoyJavaSourceFunction function, List<SoyExpression> args, @Nullable TemplateParameterLookup parameters, ExpressionDetacher detacher) {
        return this.compile(JavaPluginExecContext.forFunctionNode(node, function), args, parameters, detacher);
    }

    private SoyExpression compile(JavaPluginExecContext context, List<SoyExpression> args, @Nullable TemplateParameterLookup parameters, ExpressionDetacher detacher) {
        return new JbcSrcValueFactory(context, parameters == null ? new JbcSrcPluginContext(){

            private Expression error() {
                throw new UnsupportedOperationException("Cannot access contextual data from a pure context");
            }

            @Override
            public Expression getBidiGlobalDir() {
                return this.error();
            }

            @Override
            public Expression getAllRequiredCssNamespaces(SoyExpression template) {
                return this.error();
            }

            @Override
            public Expression getAllRequiredCssPaths(SoyExpression template) {
                return this.error();
            }

            @Override
            public Expression getULocale() {
                return this.error();
            }
        } : parameters.getPluginContext(), pluginName -> {
            if (parameters == null) {
                throw new UnsupportedOperationException("Pure functions cannot have instances");
            }
            return parameters.getRenderContext().getPluginInstance(pluginName);
        }, this.errorReporter, this.typeRegistry, detacher).computeForJavaSource(args);
    }
}

