/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.internal.exemptions.NamespaceExemptions;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.SoyFileCompiler;
import com.google.template.soy.jbcsrc.internal.AbstractMemoryClassLoader;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class CompilingClassLoader
extends AbstractMemoryClassLoader {
    private final Map<String, ClassData> classesByName = Collections.synchronizedMap(new HashMap());
    private final ImmutableMap<SourceFilePath, SoyFileSupplier> filePathsToSuppliers;
    private final ImmutableMap<String, SoyFileNode> javaClassNameToFile;
    private final SoyTypeRegistry typeRegistry;
    private final PartialFileSetMetadata fileSetMetadata;

    CompilingClassLoader(SoyFileSetNode fileSet, ImmutableMap<SourceFilePath, SoyFileSupplier> filePathsToSuppliers, SoyTypeRegistry typeRegistry, PartialFileSetMetadata fileSetMetadata) {
        LinkedHashMap<String, SoyFileNode> javaClassNameToFile = new LinkedHashMap<String, SoyFileNode>();
        for (SoyFileNode file : fileSet.getChildren()) {
            if (NamespaceExemptions.isKnownDuplicateNamespace(file.getNamespace())) {
                for (TemplateNode template : file.getTemplates()) {
                    javaClassNameToFile.put(Names.javaClassNameFromSoyTemplateName(template.getTemplateName()), file);
                }
                continue;
            }
            javaClassNameToFile.put(Names.javaClassNameFromSoyNamespace(file.getNamespace()), file);
        }
        this.javaClassNameToFile = ImmutableMap.copyOf(javaClassNameToFile);
        this.typeRegistry = typeRegistry;
        this.filePathsToSuppliers = filePathsToSuppliers;
        this.fileSetMetadata = fileSetMetadata;
    }

    @Override
    protected ClassData getClassData(String name) {
        if (!name.startsWith("com.google.template.soy.jbcsrc.gen.")) {
            return null;
        }
        ClassData classDef = this.classesByName.remove(name);
        if (classDef != null) {
            return classDef;
        }
        SoyFileNode node = (SoyFileNode)this.javaClassNameToFile.get((Object)name);
        if (node == null) {
            return null;
        }
        ClassData clazzToLoad = null;
        ErrorReporter reporter = ErrorReporter.create(this.filePathsToSuppliers);
        for (ClassData clazz : new SoyFileCompiler(node, new JavaSourceFunctionCompiler(this.typeRegistry, reporter), this.fileSetMetadata).compile()) {
            String className = clazz.type().className();
            if (className.equals(name)) {
                clazzToLoad = clazz;
                continue;
            }
            this.classesByName.put(className, clazz);
        }
        if (reporter.hasErrors()) {
            Iterable errors = Iterables.concat(reporter.getErrors(), reporter.getWarnings());
            throw new SoyCompilationException(errors);
        }
        return clazzToLoad;
    }
}

