/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.template.soy.jbcsrc.AutoValue_CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.TemplateType;
import java.util.Optional;
import java.util.stream.Stream;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@AutoValue
abstract class CompiledTemplateMetadata {
    CompiledTemplateMetadata() {
    }

    static final Method createRenderMethod(String methodName) {
        return new Method(methodName, Type.getMethodDescriptor((Type)BytecodeUtils.RENDER_RESULT_TYPE, (Type[])new Type[]{BytecodeUtils.SOY_RECORD_TYPE, BytecodeUtils.SOY_RECORD_TYPE, BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, BytecodeUtils.RENDER_CONTEXT_TYPE}));
    }

    private static Method createPositionalRenderMethod(String methodName, TemplateType templateType) {
        return new Method(methodName, Type.getMethodDescriptor((Type)BytecodeUtils.RENDER_RESULT_TYPE, (Type[])((Type[])Stream.concat(templateType.getActualParameters().stream().map(i -> BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), Stream.of(BytecodeUtils.SOY_RECORD_TYPE, BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, BytecodeUtils.RENDER_CONTEXT_TYPE)).toArray(Type[]::new))));
    }

    private static final Method createTemplateMethod(String methodName) {
        return new Method(methodName, Type.getMethodDescriptor((Type)BytecodeUtils.COMPILED_TEMPLATE_TYPE, (Type[])new Type[0]));
    }

    static CompiledTemplateMetadata create(TemplateNode node) {
        return CompiledTemplateMetadata.create(node.getTemplateName(), TemplateMetadata.buildTemplateType(node));
    }

    static CompiledTemplateMetadata create(CallBasicNode callNode) {
        return CompiledTemplateMetadata.create(callNode.getCalleeName(), callNode.getStaticType());
    }

    private static CompiledTemplateMetadata create(String templateName, TemplateType templateType) {
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        TypeInfo type = TypeInfo.createClass(className);
        boolean hasPositionalSignature = templateType.getDataAllCallSituations().isEmpty() && !templateType.getActualParameters().isEmpty() && templateType.getTemplateKind() != TemplateType.TemplateKind.DELTEMPLATE;
        String methodName = Names.renderMethodNameFromSoyTemplateName(templateName);
        return new AutoValue_CompiledTemplateMetadata(MethodRef.createStaticMethod(type, CompiledTemplateMetadata.createRenderMethod(methodName)).asNonNullable(), Optional.ofNullable(hasPositionalSignature ? MethodRef.createStaticMethod(type, CompiledTemplateMetadata.createPositionalRenderMethod(methodName, templateType)).asNonNullable() : null), MethodRef.createStaticMethod(type, CompiledTemplateMetadata.createTemplateMethod(methodName)).asCheap().asNonNullable(), templateType, type);
    }

    abstract MethodRef renderMethod();

    abstract Optional<MethodRef> positionalRenderMethod();

    abstract MethodRef templateMethod();

    boolean hasPositionalSignature() {
        return this.positionalRenderMethod().isPresent();
    }

    abstract TemplateType templateType();

    abstract TypeInfo typeInfo();
}

