/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.invocationbuilders.javatypes;

import com.google.template.soy.invocationbuilders.javatypes.CodeGenUtils;
import com.google.template.soy.invocationbuilders.javatypes.JavaType;

public final class ListJavaType
extends JavaType {
    private final JavaType elementType;
    private static final CodeGenUtils.Member AS_LIST = CodeGenUtils.castFunction("asList");
    private static final CodeGenUtils.Member AS_NULLABLE_LIST = CodeGenUtils.castFunction("asNullableList");

    public ListJavaType(JavaType elementType) {
        this(elementType, false);
    }

    public ListJavaType(JavaType elementType, boolean isNullable) {
        super(isNullable);
        this.elementType = elementType;
    }

    @Override
    public String toJavaTypeString() {
        return "java.lang.Iterable<" + this.elementType.asGenericsTypeArgumentString() + ">";
    }

    @Override
    String asGenericsTypeArgumentString() {
        return "? extends java.util.Collection<" + this.elementType.asGenericsTypeArgumentString() + ">";
    }

    @Override
    public String asInlineCast(String variableName, int depth) {
        return (this.isNullable() ? AS_NULLABLE_LIST : AS_LIST) + "(" + variableName + ", " + this.elementType.getAsInlineCastFunction(depth) + ")";
    }

    JavaType getElementType() {
        return this.elementType;
    }

    @Override
    public ListJavaType asNullable() {
        return new ListJavaType(this.elementType, true);
    }
}

