/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.proto;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.ProtoFlavor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class JavaQualifiedNames {
    private static final String[] forbiddenWords = new String[]{"InitializationErrorString", "CachedSize", "Class", "SerializedSize", "DefaultInstanceForType", "ParserForType", "AllFields", "DescriptorForType"};
    private static final Set<String> specialCases = new HashSet<String>(Arrays.asList(forbiddenWords));

    private JavaQualifiedNames() {
    }

    public static String getPackage(Descriptors.FileDescriptor fileDescriptor) {
        return JavaQualifiedNames.getPackage(fileDescriptor, ProtoFlavor.PROTO2);
    }

    static String getPackage(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        return JavaQualifiedNames.getPackage(file.toProto(), flavor);
    }

    static String getPackage(DescriptorProtos.FileDescriptorProto file, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions fileOptions = file.getOptions();
        StringBuilder sb = new StringBuilder();
        if (fileOptions.hasJavaPackage()) {
            sb.append(fileOptions.getJavaPackage());
        } else if (!file.getPackage().isEmpty()) {
            sb.append(file.getPackage());
        }
        return sb.toString();
    }

    public static String getOuterClassname(Descriptors.FileDescriptor fileDescriptor) {
        return JavaQualifiedNames.getFileClassName(fileDescriptor, ProtoFlavor.PROTO2);
    }

    public static String getQualifiedName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getClassName(msg).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getClassName(enumType).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.Descriptor msg, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(msg, flavor).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(enumType, flavor).replace('$', '.');
    }

    public static String getClassName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getClassName(msg, ProtoFlavor.PROTO2);
    }

    public static String getClassName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getClassName(enumType, ProtoFlavor.PROTO2);
    }

    public static String getClassName(Descriptors.Descriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor, flavor), descriptor.getFile(), flavor);
    }

    public static String getClassName(Descriptors.EnumDescriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor, flavor), descriptor.getFile(), flavor);
    }

    private static String getClassName(String nameWithoutPackage, Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        StringBuilder sb = new StringBuilder();
        if (JavaQualifiedNames.multipleJavaFiles(file, flavor)) {
            sb.append(JavaQualifiedNames.getPackage(file, flavor));
            if (sb.length() > 0) {
                sb.append('.');
            }
        } else {
            sb.append(JavaQualifiedNames.getClassName(file, flavor));
            if (sb.length() > 0) {
                sb.append('$');
            }
        }
        sb.append(nameWithoutPackage.replace('.', '$'));
        return sb.toString();
    }

    private static String getClassName(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaQualifiedNames.getPackage(file, flavor));
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(JavaQualifiedNames.getFileClassName(file, flavor));
        return sb.toString();
    }

    public static String getFieldName(Descriptors.FieldDescriptor field, boolean capitalizeFirstLetter) {
        String fieldName = field.getName();
        String javaName = JavaQualifiedNames.underscoresToCamelCase(fieldName, capitalizeFirstLetter);
        if (specialCases.contains(javaName)) {
            return javaName + '_';
        }
        return javaName;
    }

    public static String getCaseEnumClassName(Descriptors.OneofDescriptor oneOfDescriptor) {
        return JavaQualifiedNames.getClassName(oneOfDescriptor.getContainingType()) + '$' + JavaQualifiedNames.underscoresToCamelCase(oneOfDescriptor.getName(), true) + "Case";
    }

    public static String underscoresToCamelCase(String input, boolean capitalizeNextLetter) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                if (capitalizeNextLetter) {
                    result.append((char)(ch + -32));
                } else {
                    result.append(ch);
                }
                capitalizeNextLetter = false;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                if (i == 0 && !capitalizeNextLetter) {
                    result.append((char)(ch + 32));
                } else {
                    result.append(ch);
                }
                capitalizeNextLetter = false;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                result.append(ch);
                capitalizeNextLetter = true;
                continue;
            }
            capitalizeNextLetter = true;
        }
        return result.toString();
    }

    private static String classNameWithoutPackage(Descriptors.Descriptor descriptor, ProtoFlavor flavor) {
        String name = JavaQualifiedNames.stripPackageName(descriptor.getFullName(), descriptor.getFile());
        return name;
    }

    private static String classNameWithoutPackage(Descriptors.EnumDescriptor descriptor, ProtoFlavor flavor) {
        Descriptors.Descriptor messageDescriptor = descriptor.getContainingType();
        if (messageDescriptor == null) {
            return descriptor.getName();
        }
        return JavaQualifiedNames.classNameWithoutPackage(messageDescriptor, flavor) + '.' + descriptor.getName();
    }

    private static String stripPackageName(String fullName, Descriptors.FileDescriptor file) {
        if (file.getPackage().isEmpty()) {
            return fullName;
        }
        return fullName.substring(file.getPackage().length() + 1);
    }

    private static boolean multipleJavaFiles(Descriptors.FileDescriptor fd, ProtoFlavor flavor) {
        return JavaQualifiedNames.multipleJavaFiles(fd.toProto(), flavor);
    }

    private static boolean multipleJavaFiles(DescriptorProtos.FileDescriptorProto fd, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions options = fd.getOptions();
        switch (flavor) {
            case PROTO2: {
                return options.getJavaMultipleFiles();
            }
        }
        throw new AssertionError();
    }

    static String getFileClassName(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        return JavaQualifiedNames.getFileClassName(file.toProto(), flavor);
    }

    static String getFileClassName(DescriptorProtos.FileDescriptorProto file, ProtoFlavor flavor) {
        switch (flavor) {
            case PROTO2: {
                return JavaQualifiedNames.getFileImmutableClassName(file);
            }
        }
        throw new AssertionError();
    }

    private static String getFileImmutableClassName(DescriptorProtos.FileDescriptorProto file) {
        if (file.getOptions().hasJavaOuterClassname()) {
            return file.getOptions().getJavaOuterClassname();
        }
        String className = JavaQualifiedNames.getFileDefaultImmutableClassName(file);
        if (JavaQualifiedNames.hasConflictingClassName(file, className)) {
            return className + "OuterClass";
        }
        return className;
    }

    private static String getFileDefaultImmutableClassName(DescriptorProtos.FileDescriptorProto file) {
        String name = file.getName();
        int lastSlash = name.lastIndexOf(47);
        String basename = lastSlash < 0 ? name : name.substring(lastSlash + 1);
        return JavaQualifiedNames.underscoresToCamelCase(JavaQualifiedNames.stripProto(basename), true);
    }

    private static String stripProto(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            switch (filename.substring(lastDot)) {
                case ".protodevel": 
                case ".proto": {
                    return filename.substring(0, lastDot);
                }
            }
            throw new AssertionError();
        }
        return filename;
    }

    private static boolean hasConflictingClassName(DescriptorProtos.DescriptorProto messageDesc, String name) {
        if (name.equals(messageDesc.getName())) {
            return true;
        }
        for (DescriptorProtos.EnumDescriptorProto enumDesc : messageDesc.getEnumTypeList()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.DescriptorProto nestedMessageDesc : messageDesc.getNestedTypeList()) {
            if (!JavaQualifiedNames.hasConflictingClassName(nestedMessageDesc, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConflictingClassName(DescriptorProtos.FileDescriptorProto file, String name) {
        for (DescriptorProtos.EnumDescriptorProto enumDesc : file.getEnumTypeList()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.ServiceDescriptorProto serviceDesc : file.getServiceList()) {
            if (!name.equals(serviceDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.DescriptorProto messageDesc : file.getMessageTypeList()) {
            if (!JavaQualifiedNames.hasConflictingClassName(messageDesc, name)) continue;
            return true;
        }
        return false;
    }

    static {
        for (String word : forbiddenWords) {
            String lowerCase = word.toLowerCase(Locale.US).charAt(0) + word.substring(1);
            specialCases.add(lowerCase);
        }
    }
}

