/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.incrementaldomsrc.BidiUnicodeWrapDirective;
import com.google.template.soy.incrementaldomsrc.EscapeHtmlDirective;
import com.google.template.soy.incrementaldomsrc.FilterHtmlAttributesDirective;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class RemoveUnnecessaryEscapingDirectives {
    private final ImmutableMap<String, SoyLibraryAssistedJsSrcPrintDirective> directives;
    private static final String BIDI_UNICODE_WRAP = "|bidiUnicodeWrap";
    private static final ImmutableSet<String> SKIPPABLE_ESCAPING_MODES = ImmutableSet.of((Object)EscapingMode.ESCAPE_HTML.directiveName, (Object)EscapingMode.ESCAPE_HTML.directiveName, (Object)EscapingMode.NORMALIZE_HTML.directiveName, (Object)EscapingMode.ESCAPE_HTML_RCDATA.directiveName, (Object)EscapingMode.ESCAPE_HTML_ATTRIBUTE.directiveName, (Object)EscapingMode.ESCAPE_HTML_ATTRIBUTE_NOSPACE.directiveName, (Object[])new String[0]);

    public RemoveUnnecessaryEscapingDirectives(BidiGlobalDir bidiGlobalDir) {
        this.directives = ImmutableMap.of((Object)EscapingMode.ESCAPE_HTML.directiveName, (Object)new EscapeHtmlDirective(), (Object)EscapingMode.FILTER_HTML_ATTRIBUTES.directiveName, (Object)new FilterHtmlAttributesDirective(), (Object)BIDI_UNICODE_WRAP, (Object)new BidiUnicodeWrapDirective(bidiGlobalDir));
    }

    private NodeVisitor<Node, SoyTreeUtils.VisitDirective> getVisitor() {
        return new NodeVisitor<Node, SoyTreeUtils.VisitDirective>(){

            @Override
            public SoyTreeUtils.VisitDirective exec(Node node) {
                if (node instanceof ExprNode) {
                    return SoyTreeUtils.VisitDirective.SKIP_CHILDREN;
                }
                SoyNode soyNode = (SoyNode)node;
                switch (soyNode.getKind()) {
                    case PRINT_NODE: {
                        PrintDirectiveNode pdn2;
                        SoyPrintDirective directive;
                        PrintNode printNode = (PrintNode)soyNode;
                        for (int i = printNode.numChildren() - 1; i >= 0 && !((directive = (pdn2 = (PrintDirectiveNode)printNode.getChild(i)).getPrintDirective()) instanceof SanitizedContentOperator); --i) {
                            if (!pdn2.isSynthetic() || !RemoveUnnecessaryEscapingDirectives.canSkip(directive)) continue;
                            printNode.removeChild(i);
                        }
                        for (PrintDirectiveNode pdn2 : printNode.getChildren()) {
                            String directiveName = pdn2.getPrintDirective().getName();
                            if (printNode.getHtmlContext() == HtmlContext.TEXT && directiveName.equals(RemoveUnnecessaryEscapingDirectives.BIDI_UNICODE_WRAP) || !RemoveUnnecessaryEscapingDirectives.this.directives.containsKey((Object)directiveName)) continue;
                            printNode.replaceChild(pdn2, PrintDirectiveNode.createSyntheticNode(pdn2.getId(), Identifier.create(pdn2.getName(), pdn2.getNameLocation()), pdn2.getSourceLocation(), (SoyPrintDirective)RemoveUnnecessaryEscapingDirectives.this.directives.get((Object)directiveName)));
                        }
                        return SoyTreeUtils.VisitDirective.SKIP_CHILDREN;
                    }
                    case CALL_BASIC_NODE: 
                    case CALL_DELEGATE_NODE: {
                        CallNode callNode = (CallNode)soyNode;
                        callNode.setEscapingDirectives((ImmutableList<SoyPrintDirective>)RemoveUnnecessaryEscapingDirectives.filterEscapingDirectives((ImmutableList<SoyPrintDirective>)callNode.getEscapingDirectives()));
                        return SoyTreeUtils.VisitDirective.CONTINUE;
                    }
                    case MSG_FALLBACK_GROUP_NODE: {
                        MsgFallbackGroupNode msgNode = (MsgFallbackGroupNode)soyNode;
                        msgNode.setEscapingDirectives((ImmutableList<SoyPrintDirective>)RemoveUnnecessaryEscapingDirectives.filterEscapingDirectives((ImmutableList<SoyPrintDirective>)msgNode.getEscapingDirectives()));
                        return SoyTreeUtils.VisitDirective.CONTINUE;
                    }
                }
                return SoyTreeUtils.VisitDirective.CONTINUE;
            }
        };
    }

    void run(SoyFileSetNode fileSet) {
        NodeVisitor<Node, SoyTreeUtils.VisitDirective> visitor = this.getVisitor();
        for (SoyFileNode file : fileSet.getChildren()) {
            SoyTreeUtils.visitAllNodes(file, visitor);
        }
    }

    private static ImmutableList<SoyPrintDirective> filterEscapingDirectives(ImmutableList<SoyPrintDirective> escapingDirectives) {
        for (int i = 0; i < escapingDirectives.size(); ++i) {
            SoyPrintDirective directive = (SoyPrintDirective)escapingDirectives.get(i);
            if (!RemoveUnnecessaryEscapingDirectives.canSkip(directive)) continue;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)escapingDirectives.subList(0, i));
            while (i < escapingDirectives.size()) {
                directive = (SoyPrintDirective)escapingDirectives.get(i);
                if (!RemoveUnnecessaryEscapingDirectives.canSkip(directive)) {
                    builder.add((Object)directive);
                }
                ++i;
            }
            return builder.build();
        }
        return escapingDirectives;
    }

    private static boolean canSkip(SoyPrintDirective printDirective) {
        return SKIPPABLE_ESCAPING_MODES.contains((Object)printDirective.getName());
    }
}

