/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomCodeVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.DoWhile;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.VeLogNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

final class AssistantForHtmlMsgs
extends GenJsCodeVisitorAssistantForMsgs {
    private final Map<String, MsgPlaceholderNode> placeholderNames = new LinkedHashMap<String, MsgPlaceholderNode>();
    private static final String PLACEHOLDER_WRAPPER = "\u0001";
    private static final String PLACEHOLDER_REGEX = "/\\x01\\d+\\x01/g";
    private final String staticDecl;
    private final GenIncrementalDomCodeVisitor idomMaster;

    AssistantForHtmlMsgs(GenIncrementalDomCodeVisitor master, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter, String staticDecl) {
        super(master, jsSrcOptions, genCallCodeUtils, isComputableAsJsExprsVisitor, functionAliases, genJsExprsVisitor, translationContext, errorReporter);
        this.staticDecl = staticDecl;
        this.idomMaster = master;
    }

    @Override
    public Expression generateMsgGroupVariable(MsgFallbackGroupNode node) {
        throw new IllegalStateException("This class should only be used for via the new idom entry-point.");
    }

    CodeChunk generateMsgGroupCode(MsgFallbackGroupNode node) {
        Preconditions.checkState((boolean)this.placeholderNames.isEmpty(), (Object)"This class is not reusable.");
        Preconditions.checkArgument((node.getHtmlContext() == HtmlContext.HTML_PCDATA ? 1 : 0) != 0, (Object)"AssistantForHtmlMsgs is only for HTML {msg}s.");
        Expression translationVar = super.generateMsgGroupVariable(node);
        if (this.placeholderNames.isEmpty()) {
            Expression unescape = JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(translationVar);
            return IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(unescape);
        }
        if (!translationVar.isCheap()) {
            translationVar = this.translationContext.codeGenerator().declarationBuilder().setRhs(translationVar).build().ref();
        }
        ImmutableList.Builder body = ImmutableList.builder();
        String itemId = "i" + node.getId();
        Expression item = Expression.id("i" + node.getId());
        body.add((Object)item.bracketAccess(Expression.number(0L)).and(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(item.bracketAccess(Expression.number(0L))), this.translationContext.codeGenerator()).asStatement());
        SwitchBuilder switchBuilder = Statement.switchValue(item.bracketAccess(Expression.number(1L)));
        for (Map.Entry<String, MsgPlaceholderNode> ph : this.placeholderNames.entrySet()) {
            Statement value = this.idomMaster.visitForUseByAssistantsAsCodeChunk(ph.getValue());
            MsgPlaceholderNode phNode = ph.getValue();
            if (phNode.getParent() instanceof VeLogNode) {
                VeLogNode parent = (VeLogNode)phNode.getParent();
                if (parent.getChild(0) == phNode) {
                    GenIncrementalDomCodeVisitor.VeLogStateHolder state = this.idomMaster.openVeLogNode(parent);
                    Preconditions.checkState((state.logOnlyConditional == null ? 1 : 0) != 0);
                    value = Statement.of(state.enterStatement, value);
                }
                if (parent.getChild(parent.numChildren() - 1) == phNode) {
                    value = Statement.of(value, this.idomMaster.exitVeLogNode(parent, null));
                }
            }
            switchBuilder.addCase(Expression.stringLiteral(ph.getKey()), value);
        }
        body.add((Object)switchBuilder.build());
        Statement loop = Statement.forOf(itemId, Expression.id(this.staticDecl).bracketAccess(translationVar), Statement.of((Iterable<Statement>)body.build()));
        return Statement.of(this.staticsInitializer(node, translationVar), loop);
    }

    private Statement staticsInitializer(MsgFallbackGroupNode node, Expression translationVar) {
        VariableDeclaration regexVar = VariableDeclaration.builder("partRe_" + node.getId()).setRhs(Expression.regexLiteral(PLACEHOLDER_REGEX)).build();
        VariableDeclaration matchVar = VariableDeclaration.builder("match_" + node.getId()).setMutable().build();
        VariableDeclaration lastIndexVar = VariableDeclaration.builder("lastIndex_" + node.getId()).setMutable().setRhs(Expression.number(0L)).build();
        VariableDeclaration counter = VariableDeclaration.builder("counter_" + node.getId()).setMutable().setRhs(Expression.number(0L)).build();
        ArrayList<Statement> doBody = new ArrayList<Statement>();
        doBody.add(matchVar.ref().assign(regexVar.ref().dotAccess("exec").call(translationVar).or(Expression.id("undefined"), this.translationContext.codeGenerator())).asStatement());
        Expression endIndex = matchVar.ref().and(matchVar.ref().dotAccess("index"), this.translationContext.codeGenerator());
        Expression unescape = JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(translationVar.dotAccess("substring").call(lastIndexVar.ref(), endIndex));
        doBody.add(Expression.id(this.staticDecl).bracketAccess(translationVar).bracketAccess(counter.ref()).assign(Expression.arrayLiteral((Iterable<? extends Expression>)ImmutableList.of((Object)unescape, (Object)matchVar.ref().and(matchVar.ref().bracketAccess(Expression.number(0L)), this.translationContext.codeGenerator())))).asStatement());
        doBody.add(counter.ref().assign(counter.ref().plus(Expression.number(1L))).asStatement());
        doBody.add(lastIndexVar.ref().assign(regexVar.ref().dotAccess("lastIndex")).asStatement());
        Statement statement = Statement.of(Expression.id(this.staticDecl).bracketAccess(translationVar).assign(Expression.arrayLiteral((Iterable<? extends Expression>)ImmutableList.of())).asStatement(), Statement.of(translationVar.initialStatements()), regexVar, lastIndexVar, counter, matchVar, DoWhile.builder().setCondition(matchVar.ref()).setBody(Statement.of(doBody)).build());
        statement = Statement.ifStatement(Expression.not(Expression.id(this.staticDecl).bracketAccess(translationVar)), statement).build();
        return statement;
    }

    @Override
    protected Expression genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
        String name = PLACEHOLDER_WRAPPER + this.placeholderNames.size() + PLACEHOLDER_WRAPPER;
        this.placeholderNames.put(name, msgPhNode);
        return Expression.stringLiteral(name);
    }
}

