/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.types.SoyType;
import javax.annotation.Nullable;

public final class VarRefNode
extends AbstractExprNode {
    private final String originalName;
    private final String name;
    private VarDefn defn;
    private SoyType substituteType;

    public static VarRefNode error(SourceLocation location) {
        return new VarRefNode("$error", location, null);
    }

    public VarRefNode(String name, SourceLocation sourceLocation, @Nullable VarDefn defn) {
        super(sourceLocation);
        this.originalName = name;
        this.name = name.startsWith(".") ? name.substring(1) : name;
        this.defn = defn;
    }

    private VarRefNode(VarRefNode orig, CopyState copyState) {
        super(orig, copyState);
        this.originalName = orig.originalName;
        this.name = orig.name;
        this.substituteType = orig.substituteType;
        if (orig.defn != null) {
            this.defn = orig.defn;
            copyState.registerRefListener(orig.defn, this::setDefn);
        }
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.VAR_REF_NODE;
    }

    @Override
    public SoyType getType() {
        Preconditions.checkState((this.defn != null ? 1 : 0) != 0);
        return this.substituteType != null ? this.substituteType : this.defn.type();
    }

    public boolean hasType() {
        return this.defn != null && (this.substituteType != null || this.defn.hasType());
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutLeadingDollar() {
        return this.name.startsWith("$") ? this.name.substring(1) : this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public boolean originallyLeadingDot() {
        return this.originalName.charAt(0) == '.';
    }

    public boolean isInjected() {
        return this.defn.isInjected();
    }

    public void setDefn(VarDefn defn) {
        this.defn = defn;
    }

    public VarDefn getDefnDecl() {
        return this.defn;
    }

    public void setSubstituteType(SoyType type) {
        this.substituteType = type;
    }

    @Override
    public String toSourceString() {
        return this.originalName;
    }

    @Override
    public VarRefNode copy(CopyState copyState) {
        return new VarRefNode(this, copyState);
    }
}

