/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;

public final class MapLiteralFromListNode
extends AbstractParentExprNode {
    public static final String KEY_STRING = "key";
    public static final String VALUE_STRING = "value";
    public static final ImmutableSet<String> MAP_RECORD_FIELDS = ImmutableSet.of((Object)"key", (Object)"value");
    private final Identifier mapIdentifier;
    private int nodeId;

    public MapLiteralFromListNode(Identifier ident, ExprNode listExpr, SourceLocation sourceLocation, int nodeId) {
        super(sourceLocation);
        this.mapIdentifier = ident;
        this.nodeId = nodeId;
        this.addChild(listExpr);
    }

    private MapLiteralFromListNode(MapLiteralFromListNode orig, CopyState copyState) {
        super(orig, copyState);
        this.mapIdentifier = orig.mapIdentifier;
        this.nodeId = orig.nodeId;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.MAP_LITERAL_FROM_LIST_NODE;
    }

    public ExprNode getListExpr() {
        return (ExprNode)Preconditions.checkNotNull((Object)this.getChild(0));
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public String toSourceString() {
        return String.format("map(%s)", this.getListExpr().toSourceString());
    }

    @Override
    public MapLiteralFromListNode copy(CopyState copyState) {
        return new MapLiteralFromListNode(this, copyState);
    }
}

