/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MethodCallNode;
import java.util.List;

public final class CallableExprBuilder {
    private Identifier identifier;
    private SourceLocation sourceLocation;
    private List<Identifier> paramNames;
    private List<ExprNode> paramValues;
    private List<SourceLocation.Point> commaLocations;
    private boolean isNullSafe;
    private ExprNode target;
    private ExprNode functionExpr;

    public static CallableExprBuilder builder() {
        return new CallableExprBuilder();
    }

    public static CallableExprBuilder builder(MethodCallNode from) {
        return new CallableExprBuilder().setTarget(from.getBaseExprChild()).fillFrom(from);
    }

    public static CallableExprBuilder builder(FunctionNode from) {
        CallableExprBuilder builder = new CallableExprBuilder().fillFrom(from);
        if (!from.hasStaticName()) {
            builder.setFunctionExpr(from.getNameExpr());
        }
        return builder;
    }

    private CallableExprBuilder() {
    }

    private CallableExprBuilder fillFrom(ExprNode.CallableExpr from) {
        this.setSourceLocation(from.getSourceLocation());
        this.setIdentifier(from.getIdentifier());
        this.setParamValues(from.getParams());
        this.setCommaLocations(from.getCommaLocations().orElse(null));
        switch (from.getParamsStyle()) {
            case NAMED: {
                this.setParamNames((List<Identifier>)from.getParamNames());
                break;
            }
        }
        return this;
    }

    public CallableExprBuilder setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public CallableExprBuilder setFunctionExpr(ExprNode functionExpr) {
        this.functionExpr = functionExpr;
        return this;
    }

    public CallableExprBuilder setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public CallableExprBuilder setParamNames(List<Identifier> paramNames) {
        this.paramNames = paramNames;
        return this;
    }

    public CallableExprBuilder setParamValues(List<ExprNode> paramValues) {
        this.paramValues = paramValues;
        return this;
    }

    public CallableExprBuilder setCommaLocations(List<SourceLocation.Point> commaLocations) {
        this.commaLocations = commaLocations;
        return this;
    }

    public CallableExprBuilder setNullSafe(boolean nullSafe) {
        this.isNullSafe = nullSafe;
        return this;
    }

    public CallableExprBuilder setTarget(ExprNode target) {
        this.target = target;
        return this;
    }

    private ExprNode.CallableExpr.ParamsStyle buildParamsStyle() {
        if (this.paramValues.isEmpty()) {
            Preconditions.checkState((this.paramNames == null || this.paramNames.isEmpty() ? 1 : 0) != 0);
            return ExprNode.CallableExpr.ParamsStyle.NONE;
        }
        if (this.paramNames != null) {
            Preconditions.checkState((this.paramValues.size() == this.paramNames.size() ? 1 : 0) != 0);
            return ExprNode.CallableExpr.ParamsStyle.NAMED;
        }
        return ExprNode.CallableExpr.ParamsStyle.POSITIONAL;
    }

    public MethodCallNode buildMethod() {
        Preconditions.checkState((this.target != null ? 1 : 0) != 0);
        MethodCallNode node = new MethodCallNode(this.target, this.isNullSafe, this.sourceLocation, this.identifier, this.buildParamsStyle(), (ImmutableList<Identifier>)(this.paramNames != null ? ImmutableList.copyOf(this.paramNames) : ImmutableList.of()));
        node.addChildren((List<? extends ExprNode>)this.paramValues);
        return node;
    }

    public FunctionNode buildFunction() {
        Preconditions.checkState((this.target == null ? 1 : 0) != 0);
        Preconditions.checkState((!this.isNullSafe ? 1 : 0) != 0);
        FunctionNode node = new FunctionNode(this.sourceLocation, this.identifier, this.functionExpr, this.buildParamsStyle(), (ImmutableList<Identifier>)(this.paramNames != null ? ImmutableList.copyOf(this.paramNames) : ImmutableList.of()), this.commaLocations != null ? ImmutableList.copyOf(this.commaLocations) : null);
        node.addChildren((List<? extends ExprNode>)this.paramValues);
        return node;
    }
}

