/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrors;

public final class SoyInternalCompilerException
extends RuntimeException {
    private final ImmutableList<SoyError> errors;

    public SoyInternalCompilerException(Iterable<SoyError> errors, Throwable cause) {
        super(cause);
        this.errors = ImmutableList.sortedCopyOf(errors);
        Preconditions.checkArgument((!this.errors.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    public String getMessage() {
        return "Unrecoverable internal Soy error. Prior to failure found " + SoyErrors.formatErrors(this.errors);
    }
}

