/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public final class ParamStore
extends SoyAbstractValue
implements SoyRecord {
    private final Map<String, SoyValueProvider> localStore;
    public static final ParamStore EMPTY_INSTANCE = new ParamStore(true);

    public ParamStore(SoyRecord backingStore, int size) {
        this.localStore = Maps.newHashMapWithExpectedSize((int)(backingStore.recordSize() + size));
        backingStore.forEach(this.localStore::put);
    }

    private ParamStore(boolean unused) {
        this.localStore = ImmutableMap.of();
    }

    public ParamStore(int size) {
        this.localStore = Maps.newHashMapWithExpectedSize((int)size);
    }

    public ParamStore setField(String name, @Nonnull SoyValueProvider valueProvider) {
        Preconditions.checkNotNull((Object)valueProvider);
        this.localStore.put(name, valueProvider);
        return this;
    }

    public ParamStore setFieldCritical(String name, @Nonnull SoyValueProvider valueProvider) {
        Preconditions.checkNotNull((Object)valueProvider);
        SoyValueProvider previous = this.localStore.put(name, valueProvider);
        Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"value already set for param %s", (Object)name);
        return this;
    }

    @Override
    public boolean hasField(String name) {
        return this.localStore.containsKey(name);
    }

    @Override
    public SoyValueProvider getFieldProvider(String name) {
        return this.localStore.get(name);
    }

    @Override
    public ImmutableMap<String, SoyValueProvider> recordAsMap() {
        return ImmutableMap.copyOf(this.localStore);
    }

    @Override
    public void forEach(BiConsumer<String, ? super SoyValueProvider> action) {
        this.localStore.forEach(action);
    }

    @Override
    public int recordSize() {
        return this.localStore.size();
    }

    @Override
    public SoyValue getField(String name) {
        SoyValueProvider valueProvider = this.getFieldProvider(name);
        return valueProvider != null ? valueProvider.resolve() : null;
    }

    @Override
    public boolean coerceToBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String coerceToString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean equals(Object other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().toString();
    }
}

