/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SoyValueUnconverter {
    private static final SoyValueConverter.TypeMap<Object> CONVERTERS = new SoyValueConverter.TypeMap();

    private SoyValueUnconverter() {
    }

    public static Object unconvert(SoyValueProvider provider) {
        if (provider == null) {
            return null;
        }
        SoyValue soyValue = provider.resolve();
        return SoyValueUnconverter.unconvertInternal(soyValue);
    }

    private static <T extends SoyValue> Object unconvertInternal(T soyValue) {
        Class<?> valueClass = soyValue.getClass();
        Function<?, Object> converter = CONVERTERS.getConverter(valueClass);
        if (converter != null) {
            return converter.apply(soyValue);
        }
        throw new IllegalArgumentException("Can't unconvert values of type: " + soyValue.getClass().getName());
    }

    static {
        CONVERTERS.put(NullData.class, v -> null);
        CONVERTERS.put(BooleanData.class, BooleanData::getValue);
        CONVERTERS.put(IntegerData.class, IntegerData::getValue);
        CONVERTERS.put(FloatData.class, FloatData::getValue);
        CONVERTERS.put(StringData.class, StringData::getValue);
        CONVERTERS.put(SoyList.class, v -> v.asResolvedJavaList().stream().map(SoyValueUnconverter::unconvert).collect(Collectors.toList()));
        CONVERTERS.put(SoyMap.class, v -> {
            LinkedHashMap unconverted = new LinkedHashMap();
            v.asJavaMap().forEach((key, value) -> unconverted.put(SoyValueUnconverter.unconvert(key), SoyValueUnconverter.unconvert(value)));
            return unconverted;
        });
        CONVERTERS.put(SoyProtoValue.class, SoyProtoValue::getProto);
        CONVERTERS.put(SoyRecord.class, v -> {
            LinkedHashMap unconverted = new LinkedHashMap();
            v.forEach((key, value) -> unconverted.put(key, SoyValueUnconverter.unconvert(value)));
            return unconverted;
        });
        CONVERTERS.put(SanitizedContent.class, sc -> {
            switch (sc.getContentKind()) {
                case ATTRIBUTES: {
                    return sc;
                }
                case CSS: {
                    try {
                        return sc.toSafeStyle();
                    }
                    catch (IllegalStateException e) {
                        return sc.toSafeStyleSheet();
                    }
                }
                case HTML: {
                    return sc.toSafeHtml();
                }
                case JS: {
                    return sc.toSafeScript();
                }
                case TRUSTED_RESOURCE_URI: {
                    return sc.toTrustedResourceUrl();
                }
                case URI: {
                    return sc.toSafeUrl();
                }
            }
            throw new IllegalArgumentException(sc.getContentKind().toString());
        });
    }
}

