/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.CssParam;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyEasyList;
import com.google.template.soy.data.SoyFutureValueProvider;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.EasyListImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SoyValueConverter {
    public static final SoyValueConverter INSTANCE = new SoyValueConverter();
    private final TypeMap<SoyValueProvider> cheapConverterMap = new TypeMap();
    private final TypeMap<SoyValueProvider> expensiveConverterMap = new TypeMap();

    private SoyValueConverter() {
        this.cheapConverterMap.put(SoyValueProvider.class, input -> {
            throw new AssertionError((Object)"shouldn't get here.");
        });
        this.cheapConverterMap.put(String.class, StringData::forValue);
        this.cheapConverterMap.put(Boolean.class, BooleanData::forValue);
        this.cheapConverterMap.put(Integer.class, input -> IntegerData.forValue(input.longValue()));
        this.cheapConverterMap.put(Long.class, IntegerData::forValue);
        this.cheapConverterMap.put(Float.class, input -> FloatData.forValue(input.doubleValue()));
        this.cheapConverterMap.put(Double.class, FloatData::forValue);
        this.cheapConverterMap.put(Future.class, f -> new SoyFutureValueProvider((Future<?>)f, this::convert));
        this.cheapConverterMap.put(Descriptors.EnumValueDescriptor.class, input -> IntegerData.forValue(input.getNumber()));
        this.cheapConverterMap.put(ProtocolMessageEnum.class, input -> IntegerData.forValue(input.getNumber()));
        this.cheapConverterMap.put(CssParam.class, SanitizedContents::fromCss);
        this.cheapConverterMap.put(SafeHtml.class, SanitizedContents::fromSafeHtml);
        this.cheapConverterMap.put(SafeHtmlProto.class, SanitizedContents::fromSafeHtmlProto);
        this.cheapConverterMap.put(SafeScript.class, SanitizedContents::fromSafeScript);
        this.cheapConverterMap.put(SafeScriptProto.class, SanitizedContents::fromSafeScriptProto);
        this.cheapConverterMap.put(SafeStyle.class, SanitizedContents::fromSafeStyle);
        this.cheapConverterMap.put(SafeStyleProto.class, SanitizedContents::fromSafeStyleProto);
        this.cheapConverterMap.put(SafeStyleSheet.class, SanitizedContents::fromSafeStyleSheet);
        this.cheapConverterMap.put(SafeStyleSheetProto.class, SanitizedContents::fromSafeStyleSheetProto);
        this.cheapConverterMap.put(SafeUrl.class, SanitizedContents::fromSafeUrl);
        this.cheapConverterMap.put(SafeUrlProto.class, SanitizedContents::fromSafeUrlProto);
        this.cheapConverterMap.put(TrustedResourceUrl.class, SanitizedContents::fromTrustedResourceUrl);
        this.cheapConverterMap.put(TrustedResourceUrlProto.class, SanitizedContents::fromTrustedResourceUrlProto);
        this.cheapConverterMap.put(Message.Builder.class, input -> SoyProtoValue.create(input.build()));
        this.cheapConverterMap.put(Message.class, SoyProtoValue::create);
        this.expensiveConverterMap.put(ByteString.class, input -> StringData.forValue(BaseEncoding.base64().encode(input.toByteArray())));
        this.expensiveConverterMap.put(Map.class, this::newDictFromMap);
        this.expensiveConverterMap.put(MarkAsSoyMap.class, input -> this.newSoyMapFromJavaMap(input.delegate()));
        this.expensiveConverterMap.put(Collection.class, this::newListFromIterable);
        this.expensiveConverterMap.put(FluentIterable.class, this::newListFromIterable);
    }

    SoyDict newDictFromMap(Map<?, ?> javaStringMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<?, ?> entry : javaStringMap.entrySet()) {
            builder.put((Object)((String)entry.getKey()), (Object)this.convertLazy(entry.getValue()));
        }
        return DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)builder.build(), RuntimeMapTypeTracker.Type.UNKNOWN);
    }

    private SoyMap newSoyMapFromJavaMap(Map<?, ?> javaMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)javaMap.size());
        for (Map.Entry<?, ?> entry : javaMap.entrySet()) {
            map.put(this.convert(entry.getKey()).resolve(), this.convertLazy(entry.getValue()));
        }
        return SoyMapImpl.forProviderMap(map);
    }

    public static Object markAsSoyMap(Map<?, ?> delegate) {
        return new MarkAsSoyMap(delegate);
    }

    @Deprecated
    public SoyEasyList newEasyListFromList(SoyList list) {
        EasyListImpl result = new EasyListImpl();
        for (SoyValueProvider soyValueProvider : list.asJavaList()) {
            result.add(soyValueProvider);
        }
        return result;
    }

    private SoyList newListFromIterable(Iterable<?> items) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object item : items) {
            builder.add((Object)this.convertLazy(item));
        }
        return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)builder.build());
    }

    @Nonnull
    public SoyValueProvider convert(@Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertCheap(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        return this.convertNonPrimitive(obj);
    }

    public SoyValueProvider convertLazy(Supplier<?> supplier) {
        return new LazyProvider(() -> this.convert(supplier.get()));
    }

    private SoyValueProvider convertLazy(final @Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertCheap(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        return new SoyAbstractCachingValueProvider(){

            @Override
            protected SoyValue compute() {
                return SoyValueConverter.this.convertNonPrimitive(obj).resolve();
            }

            @Override
            public RenderResult status() {
                return RenderResult.done();
            }
        };
    }

    private SoyValueProvider convertNonPrimitive(@Nullable Object obj) {
        SoyValueProvider converted = this.expensiveConverterMap.convert(obj);
        if (converted != null) {
            return converted;
        }
        throw new SoyDataException("Attempting to convert unrecognized object to Soy value (object type " + obj.getClass().getName() + ").");
    }

    @Nullable
    private SoyValueProvider convertCheap(@Nullable Object obj) {
        if (obj == null) {
            return NullData.INSTANCE;
        }
        if (obj instanceof SoyValueProvider) {
            return (SoyValueProvider)obj;
        }
        return this.cheapConverterMap.convert(obj);
    }

    private static final class MarkAsSoyMap {
        final Map<?, ?> delegate;

        MarkAsSoyMap(Map<?, ?> delegate) {
            this.delegate = delegate;
        }

        Map<?, ?> delegate() {
            return this.delegate;
        }
    }

    static final class TypeMap<V> {
        private final ClassValue<Function<?, ?>> converterValue = new ClassValue<Function<?, ?>>(){

            @Override
            protected Function<?, ?> computeValue(Class<?> clz) {
                Function<?, ?> c = toLoad;
                if (c != null) {
                    toLoad = null;
                    return c;
                }
                c = this.getConverterOrNull(clz.getSuperclass());
                if (c == null) {
                    for (Class<?> iface : clz.getInterfaces()) {
                        c = this.getConverterOrNull(iface);
                        if (c == null) continue;
                        return c;
                    }
                }
                return c;
            }

            private Function<?, ?> getConverterOrNull(Class<?> clz) {
                if (clz == null) {
                    return null;
                }
                return (Function)this.get(clz);
            }
        };
        private Function<?, ?> toLoad;

        TypeMap() {
        }

        <T> V convert(T o) {
            Function<?, V> converter = this.getConverter(o.getClass());
            if (converter != null) {
                return converter.apply(o);
            }
            return null;
        }

        <T> Function<T, V> getConverter(Class<T> clz) {
            return this.converterValue.get((Class)Preconditions.checkNotNull(clz));
        }

        <T> void put(Class<T> clazz, Function<? super T, ? extends V> converter) {
            this.toLoad = converter;
            Function<?, ?> loaded = this.converterValue.get(clazz);
            Preconditions.checkState((loaded == converter ? 1 : 0) != 0);
            Preconditions.checkState((this.toLoad == null ? 1 : 0) != 0);
        }
    }

    private static final class LazyProvider
    implements SoyValueProvider {
        Supplier<SoyValueProvider> delegateProvider;
        SoyValueProvider delegate;

        LazyProvider(Supplier<SoyValueProvider> delegateProvider) {
            this.delegateProvider = delegateProvider;
        }

        @Override
        public SoyValue resolve() {
            return this.delegate().resolve();
        }

        @Override
        public RenderResult status() {
            return this.delegate().status();
        }

        @Override
        public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable, boolean isLast) throws IOException {
            return this.delegate().renderAndResolve(appendable, isLast);
        }

        SoyValueProvider delegate() {
            if (this.delegate == null) {
                this.delegate = this.delegateProvider.get();
                this.delegateProvider = null;
            }
            return this.delegate;
        }
    }
}

