/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SoyTemplate;
import java.lang.reflect.Method;

public final class SoyTemplates {
    private SoyTemplates() {
    }

    public static <T extends SoyTemplate> boolean hasDefaultInstance(Class<T> type) {
        try {
            type.getDeclaredMethod("getDefaultInstance", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static <T extends SoyTemplate> T getDefaultInstance(Class<T> type) {
        try {
            Method factory = type.getDeclaredMethod("getDefaultInstance", new Class[0]);
            Object instance = factory.invoke(null, new Object[0]);
            return (T)((SoyTemplate)type.cast(instance));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No default instance for template type " + type.getName(), e);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unexpected error while calling getDefaultInstance() on " + type.getName(), e);
        }
    }

    public static <T extends SoyTemplate> SoyTemplate.Builder<T> getBuilder(Class<T> type) {
        try {
            Method factory = type.getDeclaredMethod("builder", new Class[0]);
            SoyTemplate.Builder instance = (SoyTemplate.Builder)factory.invoke(null, new Object[0]);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unexpected error while calling builder() on " + type.getName(), e);
        }
    }
}

