/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.template.soy.data.SoyTemplateParam;
import java.util.Map;

public interface SoyTemplate {
    public String getTemplateName();

    public Map<String, ?> getParamsAsMap();

    public static final class AsyncWrapper<T extends SoyTemplate> {
        private final String templateName;
        private final ListenableFuture<T> templateFuture;

        public AsyncWrapper(String templateName, ListenableFuture<T> templateFuture) {
            this.templateName = templateName;
            this.templateFuture = templateFuture;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public ListenableFuture<T> getTemplateFuture() {
            return this.templateFuture;
        }
    }

    public static interface Builder<T extends SoyTemplate> {
        public T build();

        public <V> Builder<T> setParam(SoyTemplateParam<? super V> var1, V var2);

        public <V> Builder<T> setParamFuture(SoyTemplateParam<? super V> var1, ListenableFuture<V> var2);

        public boolean hasParam(SoyTemplateParam<?> var1);
    }
}

