/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.css;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.css.AutoValue_CssRegistry;
import java.util.Map;
import java.util.Optional;

@Immutable
@AutoValue
public abstract class CssRegistry {
    public abstract ImmutableSet<String> providedSymbols();

    abstract ImmutableMap<String, String> filePathToSymbol();

    abstract Optional<ImmutableListMultimap<String, String>> classMap();

    abstract ImmutableMap<String, String> classToFilePathMap();

    abstract ImmutableMap<String, String> classToNamespaceMap();

    public abstract ImmutableList<String> checkCssList();

    public abstract boolean skipCssReferenceCheck();

    @Memoized
    public ImmutableMap<String, String> symbolToFilePath() {
        return (ImmutableMap)this.filePathToSymbol().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public boolean isInRegistry(String symbol) {
        return this.providedSymbols().contains((Object)symbol);
    }

    public String getSymbolFromFilepath(String filePath) {
        return (String)this.filePathToSymbol().get((Object)filePath);
    }

    public ImmutableList<String> allowedSymbolsToUse(String nsOrPath) {
        return this.classMap().get().get((Object)nsOrPath);
    }

    public Optional<String> maybeGetRequireCss(String className) {
        return Optional.ofNullable((String)this.classToNamespaceMap().getOrDefault((Object)className, null));
    }

    public Optional<String> maybeGetRequireCssPath(String className) {
        return Optional.ofNullable((String)this.classToFilePathMap().getOrDefault((Object)className, null));
    }

    public boolean containsClassMap() {
        return this.classMap().isPresent();
    }

    public static CssRegistry createForLocalDevelopment(ImmutableSet<String> providedSymbols, ImmutableMap<String, String> filePathToSymbol) {
        return new AutoValue_CssRegistry(providedSymbols, filePathToSymbol, Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableList<String>)ImmutableList.of(), true);
    }

    public static CssRegistry create(ImmutableSet<String> providedSymbols, ImmutableMap<String, String> filePathToSymbol) {
        return new AutoValue_CssRegistry(providedSymbols, filePathToSymbol, Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableList<String>)ImmutableList.of(), false);
    }
}

