/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.conformance.AutoValue_RuleWithExemptions;
import com.google.template.soy.conformance.Rule;

@AutoValue
abstract class RuleWithExemptions {
    RuleWithExemptions() {
    }

    static RuleWithExemptions create(Rule<? extends Node> rule, ImmutableList<String> exemptedPaths, ImmutableList<String> onlyApplyToPaths) {
        return new AutoValue_RuleWithExemptions(rule, exemptedPaths, onlyApplyToPaths);
    }

    abstract Rule<? extends Node> getRule();

    abstract ImmutableList<String> getExemptedPaths();

    abstract ImmutableList<String> getOnlyApplyToPaths();

    boolean shouldCheckConformanceFor(String filePath) {
        for (String exemptedPath : this.getExemptedPaths()) {
            if (!filePath.contains(exemptedPath)) continue;
            return false;
        }
        ImmutableList<String> onlyApplyToPaths = this.getOnlyApplyToPaths();
        if (onlyApplyToPaths.isEmpty()) {
            return true;
        }
        for (String onlyApplyToPath : onlyApplyToPaths) {
            if (!filePath.contains(onlyApplyToPath)) continue;
            return true;
        }
        return false;
    }
}

