/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

final class BanXidForCssObfuscation
extends Rule<TemplateNode> {
    private static final Pattern CLASS_PARAM_PATTERN = Pattern.compile("\\A(class|classes|\\w+Class|\\w+Classes)\\Z");

    BanXidForCssObfuscation(SoyErrorKind error) {
        super(error);
    }

    @Override
    protected void doCheckConformance(TemplateNode node, ErrorReporter errorReporter) {
        new TemplateVerifier(errorReporter, node).verify();
    }

    private class TemplateVerifier {
        private final ErrorReporter errorReporter;
        private final TemplateNode template;
        private final Map<String, LetNode> localVars = Maps.newHashMap();
        private final Set<LetNode> verifiedLocalVars = Sets.newHashSet();

        TemplateVerifier(ErrorReporter errorReporter, TemplateNode template) {
            this.errorReporter = errorReporter;
            this.template = template;
        }

        void verify() {
            this.visit(this.template);
        }

        private void visit(SoyNode node) {
            if (node instanceof LetNode) {
                this.localVars.put(((LetNode)node).getVarRefName(), (LetNode)node);
            }
            if (this.shouldBanXid(node)) {
                this.visitAndBanXid(node);
            } else if (node instanceof ParentNode) {
                for (Node child : ((ParentNode)((Object)node)).getChildren()) {
                    if (!(child instanceof SoyNode)) continue;
                    this.visit((SoyNode)child);
                }
            }
        }

        private boolean shouldBanXid(SoyNode node) {
            if (node instanceof CallParamNode && CLASS_PARAM_PATTERN.matcher(((CallParamNode)node).getKey().identifier()).matches()) {
                return true;
            }
            return node instanceof HtmlAttributeNode && ((HtmlAttributeNode)node).definitelyMatchesAttributeName("class");
        }

        private void visitAndBanXid(SoyNode node) {
            if (node instanceof SoyNode.ExprHolderNode) {
                for (ExprRootNode expr : ((SoyNode.ExprHolderNode)node).getExprList()) {
                    this.visitAndBanXidInExpressionValue(expr);
                }
            } else if (node instanceof ParentNode) {
                for (Node child : ((ParentNode)((Object)node)).getChildren()) {
                    if (!(child instanceof SoyNode)) continue;
                    this.visitAndBanXidInPrintedValue((SoyNode)child);
                }
            } else {
                this.visitAndBanXidInPrintedValue(node);
            }
        }

        private void visitAndBanXidInPrintedValue(SoyNode node) {
            if (node instanceof LetNode) {
                this.localVars.put(((LetNode)node).getVarRefName(), (LetNode)node);
            } else if (node instanceof PrintNode) {
                this.visitAndBanXidInExpressionValue(((PrintNode)node).getExpr());
            } else if (node instanceof ParentNode) {
                for (Node child : ((ParentNode)((Object)node)).getChildren()) {
                    if (!(child instanceof SoyNode)) continue;
                    this.visitAndBanXidInPrintedValue((SoyNode)child);
                }
            }
        }

        private void visitAndBanXidInExpressionValue(ExprNode node) {
            if (node instanceof FunctionNode) {
                FunctionNode fn = (FunctionNode)node;
                if ("xid".equals(fn.getFunctionName())) {
                    this.errorReporter.report(fn.getSourceLocation(), BanXidForCssObfuscation.this.error, new Object[0]);
                }
            } else if (node instanceof VarRefNode) {
                LetNode varNode = this.localVars.get(((VarRefNode)node).getName());
                if (varNode != null && this.verifiedLocalVars.add(varNode)) {
                    this.visitAndBanXid(varNode);
                }
            } else if (node instanceof OperatorNodes.ConditionalOpNode) {
                OperatorNodes.ConditionalOpNode condNode = (OperatorNodes.ConditionalOpNode)node;
                this.visitAndBanXidInExpressionValue(condNode.getChild(1));
                this.visitAndBanXidInExpressionValue(condNode.getChild(2));
            } else if (node instanceof ExprNode.ParentExprNode) {
                for (ExprNode child : ((ExprNode.ParentExprNode)node).getChildren()) {
                    this.visitAndBanXidInExpressionValue(child);
                }
            }
        }
    }
}

