/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bididirectives;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.ForwardingLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.i18n.BidiFormatter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import java.io.IOException;
import javax.annotation.Nullable;

public final class BidiDirectivesRuntime {
    private BidiDirectivesRuntime() {
    }

    public static SoyValue bidiUnicodeWrap(BidiGlobalDir dir, SoyValue value) {
        value = value == null ? NullData.INSTANCE : value;
        boolean isHtml = false;
        Dir valueDir = null;
        if (value instanceof SanitizedContent) {
            SanitizedContent sanitizedContent = (SanitizedContent)value;
            isHtml = sanitizedContent.getContentKind() == SanitizedContent.ContentKind.HTML;
            valueDir = sanitizedContent.getContentDirection();
        }
        BidiFormatter bidiFormatter = BidiFormatter.getInstance(dir.toDir());
        String wrappedValue = bidiFormatter.unicodeWrap(valueDir, value.coerceToString(), isHtml);
        if (isHtml) {
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(wrappedValue, SanitizedContent.ContentKind.HTML, dir.toDir());
        }
        return StringData.forValue(wrappedValue);
    }

    public static LoggingAdvisingAppendable bidiUnicodeWrapStreaming(LoggingAdvisingAppendable delegateAppendable, BidiGlobalDir dir) {
        return new BidiWrapAppendable(delegateAppendable, dir, WrapType.UNICODE);
    }

    public static String bidiSpanWrap(BidiGlobalDir dir, SoyValue value) {
        Dir valueDir = null;
        if (value instanceof SanitizedContent) {
            valueDir = ((SanitizedContent)value).getContentDirection();
        }
        BidiFormatter bidiFormatter = BidiFormatter.getInstance(dir.toDir());
        String wrappedValue = bidiFormatter.spanWrap(valueDir, value.coerceToString(), true);
        return wrappedValue;
    }

    public static LoggingAdvisingAppendable bidiSpanWrapStreaming(LoggingAdvisingAppendable delegateAppendable, BidiGlobalDir dir) {
        return new BidiWrapAppendable(delegateAppendable, dir, WrapType.SPAN);
    }

    private static final class BidiWrapAppendable
    extends ForwardingLoggingAdvisingAppendable {
        private final BidiGlobalDir globalDir;
        private final WrapType wrapType;
        private final StringBuilder buffer;
        private final LoggingAdvisingAppendable.BufferingAppendable commandBuffer;

        BidiWrapAppendable(LoggingAdvisingAppendable delegate, BidiGlobalDir globalDir, WrapType wrapType) {
            super(delegate);
            this.globalDir = globalDir;
            this.wrapType = (WrapType)((Object)Preconditions.checkNotNull((Object)((Object)wrapType)));
            this.buffer = new StringBuilder();
            this.commandBuffer = LoggingAdvisingAppendable.buffering();
        }

        @Override
        protected void notifyKindAndDirectionality(SanitizedContent.ContentKind kind, @Nullable Dir dir) throws IOException {
            this.commandBuffer.setKindAndDirectionality(kind, dir);
        }

        @Override
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            this.commandBuffer.enterLoggableElement(statement);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable exitLoggableElement() {
            this.commandBuffer.exitLoggableElement();
            return this;
        }

        @Override
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            this.commandBuffer.appendLoggingFunctionInvocation(funCall, (ImmutableList)escapers);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable append(char c) throws IOException {
            this.buffer.append(c);
            this.commandBuffer.append(c);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable append(CharSequence csq) throws IOException {
            this.buffer.append(csq);
            this.commandBuffer.append(csq);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
            this.buffer.append(csq, start, end);
            this.commandBuffer.append(csq, start, end);
            return this;
        }

        @Override
        public void flushBuffers(int depth) throws IOException {
            BidiFormatter.BidiWrappingText wrappingText;
            BidiFormatter formatter = BidiFormatter.getInstance(this.globalDir.toDir());
            switch (this.wrapType) {
                case SPAN: {
                    wrappingText = formatter.spanWrappingText(this.getSanitizedContentDirectionality(), this.buffer.toString(), true);
                    break;
                }
                case UNICODE: {
                    wrappingText = formatter.unicodeWrappingText(this.getSanitizedContentDirectionality(), this.buffer.toString(), this.getSanitizedContentKind() == SanitizedContent.ContentKind.HTML);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid wrap type: " + (Object)((Object)this.wrapType));
                }
            }
            this.delegate.append(wrappingText.beforeText());
            this.commandBuffer.replayOn(this.delegate);
            this.delegate.append(wrappingText.afterText());
            super.flushBuffers(depth);
        }
    }

    private static enum WrapType {
        SPAN,
        UNICODE;

    }
}

