/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptPluginContext;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValue;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValueFactory;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import com.google.template.soy.plugin.python.restricted.PythonPluginContext;
import com.google.template.soy.plugin.python.restricted.PythonValue;
import com.google.template.soy.plugin.python.restricted.PythonValueFactory;
import com.google.template.soy.plugin.python.restricted.SoyPythonSourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.lang.reflect.Method;
import java.util.List;

@SoyFunctionSignature(name="round", value={@Signature(returnType="?", parameterTypes={"?"}), @Signature(returnType="?", parameterTypes={"?", "?"})})
@SoyPureFunction
public final class RoundFunction
implements SoyJavaSourceFunction,
SoyJavaScriptSourceFunction,
SoyPythonSourceFunction {
    @Override
    public JavaScriptValue applyForJavaScriptSource(JavaScriptValueFactory factory, List<JavaScriptValue> args, JavaScriptPluginContext context) {
        if (args.size() == 1) {
            return factory.global("Math").invokeMethod("round", args.get(0));
        }
        return factory.callNamespaceFunction("soy", "soy.$$round", args.get(0), args.get(1));
    }

    @Override
    public PythonValue applyForPythonSource(PythonValueFactory factory, List<PythonValue> args, PythonPluginContext context) {
        return factory.global("runtime.soy_round").call(args.get(0), args.size() > 1 ? args.get(1) : factory.constant(0L));
    }

    @Override
    public JavaValue applyForJavaSource(JavaValueFactory factory, List<JavaValue> args, JavaPluginContext context) {
        if (args.size() == 1) {
            return factory.callStaticMethod(Methods.BOXED_ROUND_FN, args.get(0));
        }
        return factory.callStaticMethod(Methods.BOXED_ROUND_WITH_NUM_DIGITS_AFTER_POINT_FN, args.get(0), args.get(1).asSoyInt());
    }

    private static final class Methods {
        static final Method BOXED_ROUND_FN = JavaValueFactory.createMethod(BasicFunctionsRuntime.class, "round", SoyValue.class);
        static final Method BOXED_ROUND_WITH_NUM_DIGITS_AFTER_POINT_FN = JavaValueFactory.createMethod(BasicFunctionsRuntime.class, "round", SoyValue.class, Integer.TYPE);

        private Methods() {
        }
    }
}

