/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.AutoValue_SourceFilePath;

@Immutable
@AutoValue
public abstract class SourceFilePath
implements Comparable<SourceFilePath> {
    public static SourceFilePath create(String path) {
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_SourceFilePath(path);
    }

    SourceFilePath() {
    }

    public abstract String path();

    public final String fileName() {
        String path = this.path();
        int lastSlashIndex = CharMatcher.anyOf((CharSequence)"/\\").lastIndexIn((CharSequence)path);
        if (lastSlashIndex != -1 && lastSlashIndex != path.length() - 1) {
            return path.substring(lastSlashIndex + 1);
        }
        return path;
    }

    @Override
    public int compareTo(SourceFilePath o) {
        return this.path().compareTo(o.path());
    }
}

