/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import java.io.IOException;
import java.util.Map;

public final class SoyUtils {
    private SoyUtils() {
    }

    public static void generateConstantsFile(String namespace, Map<String, ?> constantNameToJavaValue, Appendable output) throws IOException {
        ImmutableMap<String, PrimitiveData> constantNameToSoyValue = InternalValueUtils.convertConstantsMap(constantNameToJavaValue);
        output.append("{namespace ").append(namespace).append("}\n\n");
        for (Map.Entry entry : constantNameToSoyValue.entrySet()) {
            String valueSrcStr = InternalValueUtils.convertPrimitiveDataToExpr((PrimitiveData)entry.getValue(), SourceLocation.UNKNOWN).toSourceString();
            output.append("{export const ").append(((String)entry.getKey()).replace('.', '_')).append(" = ").append(valueSrcStr).append(" /}\n");
        }
    }
}

