/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PerInputOutputFiles;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kohsuke.args4j.Option;

public final class SoyToPySrcCompiler
extends AbstractSoyCompiler {
    @Option(name="--runtimePath", required=true, usage="[Required] The module path used to find the python runtime libraries. This should be in dot notation format.")
    private String runtimePath = "";
    @Option(name="--environmentModulePath", usage="A custom python module which will override the environment.py module if custom functionality is required for interacting with your runtime environment. This module must implement all functions of the environment module if provided.")
    private String environmentModulePath = "";
    @Option(name="--translationClass", usage="The full class name of the python runtime translation class. The name should include the absolute module path and class name in dot notation format (e.g. \"my.package.module.TranslatorClass\"). It is required for {msg} command.")
    private String translationClass = "";
    @Option(name="--bidiIsRtlFn", usage="The full name of a function used to determine if bidi is rtl for setting global directionality. The name should include the absolute module path and functionname in dot notation format (e.g. \"my.app.bidi.is_rtl\"). Only applicable if your Soy code uses bidi functions/directives.")
    private String bidiIsRtlFn = "";
    @Option(name="--namespaceManifestPaths", usage="A list of paths to a manifest file which provides a map of soy namespaces to their Python paths. If this is provided, direct imports will be used, drastically improving runtime performance.", handler=SoyCmdLineParser.StringListOptionHandler.class)
    private List<String> namespaceManifestPaths = new ArrayList<String>();
    @Option(name="--outputNamespaceManifest", usage="The name fo the manifest file containing a map of all soy namespaces to their Python paths to write. Default is to not write this file.")
    private String outputNamespaceManifest = null;
    private final PerInputOutputFiles outputFiles = new PerInputOutputFiles("py");

    SoyToPySrcCompiler(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyToPySrcCompiler() {
    }

    public static void main(String[] args) throws IOException {
        new SoyToPySrcCompiler().runMain(args);
    }

    @Override
    protected void validateFlags() {
        if (this.runtimePath.length() == 0) {
            SoyToPySrcCompiler.exitWithError("Must provide the Python runtime library path.");
        }
        this.outputFiles.validateFlags();
    }

    @Override
    Iterable<?> extraFlagsObjects() {
        return ImmutableList.of((Object)this.outputFiles);
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        SoyFileSet sfs = sfsBuilder.build();
        ImmutableMap<String, String> manifest = this.loadNamespaceManifest(this.namespaceManifestPaths);
        if (!manifest.isEmpty() && this.outputNamespaceManifest == null) {
            SoyToPySrcCompiler.exitWithError("Namespace manifests provided without outputting a new manifest.");
        }
        SoyPySrcOptions pySrcOptions = new SoyPySrcOptions(this.runtimePath, this.environmentModulePath, this.bidiIsRtlFn, this.translationClass, manifest, this.outputFiles.getOutputFilePathsForInputs((List<SourceFilePath>)sfs.getSourceFilePaths()), this.outputFiles.getOutputDirectoryFlag(), this.outputNamespaceManifest);
        this.outputFiles.writeFiles(this.srcs, sfs.compileToPySrcFiles(pySrcOptions));
    }

    private ImmutableMap<String, String> loadNamespaceManifest(List<String> namespaceManifestPaths) {
        if (namespaceManifestPaths.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder manifest = new ImmutableMap.Builder();
        for (String manifestPath : namespaceManifestPaths) {
            try {
                BufferedReader manifestFile = Files.newReader((File)new File(manifestPath), (Charset)StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    Properties prop = new Properties();
                    prop.load(manifestFile);
                    for (String namespace : prop.stringPropertyNames()) {
                        manifest.put((Object)namespace, (Object)prop.getProperty(namespace));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (manifestFile == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)manifestFile).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)manifestFile).close();
                }
            }
            catch (IOException e) {
                SoyToPySrcCompiler.exitWithError("Unable to read the namespaceManifest file at " + manifestPath);
            }
        }
        return manifest.buildOrThrow();
    }
}

