/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.kohsuke.args4j.Option;

public final class SoyToJbcSrcCompiler
extends AbstractSoyCompiler {
    @Option(name="--output", required=true, usage="[Required] The file name of the JAR file to be written.  Each compiler invocation will produce exactly one file")
    private File output;
    @Option(name="--outputSrcJar", required=false, usage="[Optional] The file name of the JAR containing sources to be written.  Each compiler invocation will produce exactly one such file.  This may be useful for enablingIDE debugging scenarios")
    private File outputSrcJar;

    SoyToJbcSrcCompiler(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyToJbcSrcCompiler() {
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        Optional<ByteSink> srcJarSink = Optional.empty();
        if (this.outputSrcJar != null) {
            srcJarSink = Optional.of(Files.asByteSink((File)this.outputSrcJar, (FileWriteMode[])new FileWriteMode[0]));
        }
        SoyToJbcSrcCompiler.compile(sfsBuilder.build(), Files.asByteSink((File)this.output, (FileWriteMode[])new FileWriteMode[0]), srcJarSink);
    }

    public static void compile(SoyFileSet sfs, ByteSink jarTarget, Optional<ByteSink> srcJarTarget) throws IOException {
        sfs.compileToJar(jarTarget, srcJarTarget);
    }

    public static void main(String[] args) {
        new SoyToJbcSrcCompiler().runMain(args);
    }
}

