/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.protobuf.Descriptors;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.MessageType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.TypeInterner;
import com.google.template.soy.types.TypeRegistry;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeDataType;
import com.google.template.soy.types.VeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class TypeRegistries {
    private static final BuiltinTypeRegistry INSTANCE = new BuiltinTypeRegistry();

    private TypeRegistries() {
    }

    public static TypeInterner newTypeInterner() {
        return new TypeInternerImpl();
    }

    public static TypeRegistry builtinTypeRegistry() {
        return INSTANCE;
    }

    public static SoyTypeRegistry newComposite(TypeRegistry typeRegistry, TypeInterner typeInterner) {
        return new CompositeSoyTypeRegistry(typeRegistry, typeInterner);
    }

    private static final class CompositeSoyTypeRegistry
    implements SoyTypeRegistry {
        private final TypeRegistry typeRegistry;
        private final TypeInterner typeInterner;

        public CompositeSoyTypeRegistry(TypeRegistry typeRegistry, TypeInterner typeInterner) {
            this.typeRegistry = typeRegistry;
            this.typeInterner = typeInterner;
        }

        @Override
        @Nullable
        public SoyType getType(String typeName) {
            return this.typeRegistry.getType(typeName);
        }

        @Override
        public String findTypeWithMatchingNamespace(String prefix) {
            return this.typeRegistry.findTypeWithMatchingNamespace(prefix);
        }

        @Override
        public Iterable<String> getAllSortedTypeNames() {
            return this.typeRegistry.getAllSortedTypeNames();
        }

        @Override
        public ListType getOrCreateListType(SoyType elementType) {
            return this.typeInterner.getOrCreateListType(elementType);
        }

        @Override
        public LegacyObjectMapType getOrCreateLegacyObjectMapType(SoyType keyType, SoyType valueType) {
            return this.typeInterner.getOrCreateLegacyObjectMapType(keyType, valueType);
        }

        @Override
        public MapType getOrCreateMapType(SoyType keyType, SoyType valueType) {
            return this.typeInterner.getOrCreateMapType(keyType, valueType);
        }

        @Override
        public SoyType getOrCreateUnionType(Collection<SoyType> members) {
            return this.typeInterner.getOrCreateUnionType(members);
        }

        @Override
        public SoyType getOrCreateUnionType(SoyType ... members) {
            return this.typeInterner.getOrCreateUnionType(members);
        }

        @Override
        public RecordType getOrCreateRecordType(Iterable<RecordType.Member> members) {
            return this.typeInterner.getOrCreateRecordType(members);
        }

        @Override
        public TemplateType internTemplateType(TemplateType typeToIntern) {
            return this.typeInterner.internTemplateType(typeToIntern);
        }

        @Override
        public VeType getOrCreateVeType(String dataType) {
            return this.typeInterner.getOrCreateVeType(dataType);
        }

        @Override
        public SoyProtoType getOrComputeProtoType(Descriptors.Descriptor descriptor, Function<? super String, ? extends SoyProtoType> mapper) {
            return this.typeInterner.getOrComputeProtoType(descriptor, mapper);
        }

        @Override
        public SoyProtoEnumType getOrCreateProtoEnumType(Descriptors.EnumDescriptor descriptor) {
            return this.typeInterner.getOrCreateProtoEnumType(descriptor);
        }
    }

    private static final class BuiltinTypeRegistry
    implements TypeRegistry {
        private static final ImmutableMap<String, SoyType> BUILTIN_TYPES = ImmutableSortedMap.naturalOrder().put((Object)"?", (Object)UnknownType.getInstance()).put((Object)"any", (Object)AnyType.getInstance()).put((Object)"null", (Object)NullType.getInstance()).put((Object)"bool", (Object)BoolType.getInstance()).put((Object)"int", (Object)IntType.getInstance()).put((Object)"float", (Object)FloatType.getInstance()).put((Object)"string", (Object)StringType.getInstance()).put((Object)"number", (Object)SoyTypes.NUMBER_TYPE).put((Object)"html", (Object)SanitizedType.HtmlType.getInstance()).put((Object)"attributes", (Object)SanitizedType.AttributesType.getInstance()).put((Object)"css", (Object)SanitizedType.StyleType.getInstance()).put((Object)"uri", (Object)SanitizedType.UriType.getInstance()).put((Object)"trusted_resource_uri", (Object)SanitizedType.TrustedResourceUriType.getInstance()).put((Object)"js", (Object)SanitizedType.JsType.getInstance()).put((Object)"ve_data", (Object)VeDataType.getInstance()).put((Object)"Message", (Object)MessageType.getInstance()).build();

        private BuiltinTypeRegistry() {
        }

        @Override
        @Nullable
        public SoyType getType(String typeName) {
            return (SoyType)BUILTIN_TYPES.get((Object)typeName);
        }

        @Override
        public String findTypeWithMatchingNamespace(String prefix) {
            return null;
        }

        public ImmutableSet<String> getAllSortedTypeNames() {
            return BUILTIN_TYPES.keySet();
        }
    }

    private static final class TypeInternerImpl
    implements TypeInterner {
        private final Interner<ListType> listTypes = Interners.newStrongInterner();
        private final Interner<MapType> mapTypes = Interners.newStrongInterner();
        private final Interner<LegacyObjectMapType> legacyObjectMapTypes = Interners.newStrongInterner();
        private final Interner<UnionType> unionTypes = Interners.newStrongInterner();
        private final Interner<RecordType> recordTypes = Interners.newStrongInterner();
        private final Interner<TemplateType> templateTypes = Interners.newStrongInterner();
        private final Interner<VeType> veTypes = Interners.newStrongInterner();
        private final Map<String, SoyProtoType> protoTypes = new ConcurrentHashMap<String, SoyProtoType>();
        private final Interner<SoyProtoEnumType> enumTypes = Interners.newStrongInterner();

        public TypeInternerImpl() {
            Preconditions.checkState((this.unionTypes.intern((Object)((UnionType)SoyTypes.NUMBER_TYPE)) == SoyTypes.NUMBER_TYPE ? 1 : 0) != 0);
        }

        @Override
        public ListType getOrCreateListType(SoyType elementType) {
            return (ListType)this.listTypes.intern((Object)ListType.of(elementType));
        }

        @Override
        public LegacyObjectMapType getOrCreateLegacyObjectMapType(SoyType keyType, SoyType valueType) {
            return (LegacyObjectMapType)this.legacyObjectMapTypes.intern((Object)LegacyObjectMapType.of(keyType, valueType));
        }

        @Override
        public MapType getOrCreateMapType(SoyType keyType, SoyType valueType) {
            return (MapType)this.mapTypes.intern((Object)MapType.of(keyType, valueType));
        }

        @Override
        public SoyType getOrCreateUnionType(Collection<SoyType> members) {
            SoyType type = UnionType.of(members);
            if (type.getKind() == SoyType.Kind.UNION) {
                type = (SoyType)this.unionTypes.intern((Object)((UnionType)type));
            }
            return type;
        }

        @Override
        public SoyType getOrCreateUnionType(SoyType ... members) {
            return this.getOrCreateUnionType(Arrays.asList(members));
        }

        @Override
        public RecordType getOrCreateRecordType(Iterable<RecordType.Member> members) {
            return (RecordType)this.recordTypes.intern((Object)RecordType.of(members));
        }

        @Override
        public TemplateType internTemplateType(TemplateType typeToIntern) {
            return (TemplateType)this.templateTypes.intern((Object)typeToIntern);
        }

        @Override
        public VeType getOrCreateVeType(String dataType) {
            return (VeType)this.veTypes.intern((Object)VeType.of(dataType));
        }

        @Override
        public SoyProtoType getOrComputeProtoType(Descriptors.Descriptor descriptor, Function<? super String, ? extends SoyProtoType> mapper) {
            return this.protoTypes.computeIfAbsent(descriptor.getFullName(), mapper);
        }

        @Override
        public SoyProtoEnumType getOrCreateProtoEnumType(Descriptors.EnumDescriptor descriptor) {
            return (SoyProtoEnumType)this.enumTypes.intern((Object)new SoyProtoEnumType(descriptor));
        }
    }
}

