/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.AutoValue_TemplateType;
import com.google.template.soy.types.AutoValue_TemplateType_DataAllCallSituation;
import com.google.template.soy.types.AutoValue_TemplateType_Parameter;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import java.util.Collection;

@AutoValue
public abstract class TemplateType
extends SoyType {
    public abstract TemplateKind getTemplateKind();

    public abstract SanitizedContentKind getContentKind();

    public abstract boolean isStrictHtml();

    public abstract ImmutableList<Parameter> getParameters();

    final ImmutableMap<String, SoyType> getParameterMap() {
        return (ImmutableMap)Streams.stream(this.getParameters()).collect(ImmutableMap.toImmutableMap(Parameter::getName, Parameter::getType));
    }

    public abstract ImmutableList<DataAllCallSituation> getDataAllCallSituations();

    public abstract String getIdentifierForDebugging();

    public abstract boolean isInferredType();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_TemplateType.Builder();
    }

    public static TemplateType declaredTypeOf(Iterable<Parameter> parameters, SoyType returnType) {
        SanitizedContentKind contentKind = returnType instanceof SanitizedType ? ((SanitizedType)returnType).getContentKind() : SanitizedContentKind.TEXT;
        return TemplateType.builder().setTemplateKind(TemplateKind.BASIC).setContentKind(contentKind).setStrictHtml(contentKind == SanitizedContentKind.HTML).setParameters((ImmutableList<Parameter>)ImmutableList.copyOf(parameters)).setDataAllCallSituations((ImmutableList<DataAllCallSituation>)ImmutableList.of()).setIdentifierForDebugging(TemplateType.stringRepresentation(parameters, contentKind)).setInferredType(false).build();
    }

    @Override
    public final SoyType.Kind getKind() {
        return SoyType.Kind.TEMPLATE;
    }

    @Override
    final boolean doIsAssignableFromNonUnionType(SoyType srcType) {
        if (srcType.getKind() == SoyType.Kind.TEMPLATE) {
            TemplateType srcTemplate = (TemplateType)srcType;
            if (!srcTemplate.getParameterMap().keySet().containsAll((Collection)this.getParameterMap().keySet())) {
                return false;
            }
            for (Parameter srcParameter : srcTemplate.getParameters()) {
                if (!this.getParameterMap().containsKey((Object)srcParameter.getName())) {
                    if (!srcParameter.isRequired()) continue;
                    return false;
                }
                SoyType thisParameterType = (SoyType)this.getParameterMap().get((Object)srcParameter.getName());
                if (srcParameter.getType().isAssignableFrom(thisParameterType)) continue;
                return false;
            }
            return srcTemplate.getContentKind().equals((Object)this.getContentKind());
        }
        return false;
    }

    @Override
    public final String toString() {
        return TemplateType.stringRepresentation(this.getParameters(), this.getContentKind());
    }

    static String stringRepresentation(Iterable<Parameter> parameters, SanitizedContentKind contentKind) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (Parameter parameter : parameters) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(parameter.getName());
            if (!parameter.isRequired()) {
                sb.append("?");
            }
            sb.append(": ");
            sb.append(parameter.getType());
        }
        sb.append(") => ");
        sb.append(SanitizedType.getTypeForContentKind(contentKind).toString());
        return sb.toString();
    }

    @Override
    final void doToProto(SoyTypeP.Builder builder) {
        Preconditions.checkState((!this.isInferredType() ? 1 : 0) != 0, (Object)"Only declared types may be serialized to proto form.");
        SoyTypeP.TemplateTypeP.Builder templateBuilder = builder.getTemplateBuilder();
        for (Parameter parameter : this.getParameters()) {
            templateBuilder.putParameter(parameter.getName(), parameter.getType().toProto());
        }
        templateBuilder.setReturnType(SanitizedType.getTypeForContentKind(this.getContentKind()).toProto().getPrimitive());
    }

    @Override
    public final <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @AutoValue
    public static abstract class DataAllCallSituation {
        public static DataAllCallSituation create(String templateName, boolean delCall, ImmutableSet<String> explicitlyPassedParameters) {
            return new AutoValue_TemplateType_DataAllCallSituation(templateName, delCall, explicitlyPassedParameters);
        }

        public abstract String getTemplateName();

        public abstract boolean isDelCall();

        public abstract ImmutableSet<String> getExplicitlyPassedParameters();
    }

    @AutoValue
    public static abstract class Parameter {
        public static Parameter create(String name, SoyType type, boolean required) {
            return new AutoValue_TemplateType_Parameter(name, type, required);
        }

        public abstract String getName();

        public abstract SoyType getType();

        public abstract boolean isRequired();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTemplateKind(TemplateKind var1);

        public abstract Builder setContentKind(SanitizedContentKind var1);

        public abstract Builder setStrictHtml(boolean var1);

        public abstract Builder setParameters(ImmutableList<Parameter> var1);

        public abstract Builder setDataAllCallSituations(ImmutableList<DataAllCallSituation> var1);

        public abstract Builder setIdentifierForDebugging(String var1);

        public abstract Builder setInferredType(boolean var1);

        public abstract TemplateType build();
    }

    public static enum TemplateKind {
        BASIC,
        DELTEMPLATE,
        ELEMENT;

    }
}

