/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyInternalCompilerException;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.types.AutoValue_SoyTypeRegistryBuilder_DescriptorKey;
import com.google.template.soy.types.DelegatingSoyTypeRegistry;
import com.google.template.soy.types.ProtoTypeRegistry;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.TypeInterner;
import com.google.template.soy.types.TypeRegistries;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class SoyTypeRegistryBuilder {
    private static final SoyErrorKind PROTO_FQN_COLLISION = SoyErrorKind.of("Identical protobuf message FQN ''{0}'' found in multiple dependencies: {1} and {2}.", new SoyErrorKind.StyleAllowance[0]);
    private final ImmutableList.Builder<Descriptors.GenericDescriptor> descriptors = ImmutableList.builder();

    public static SoyTypeRegistry create() {
        return TypeRegistries.newComposite(TypeRegistries.builtinTypeRegistry(), TypeRegistries.newTypeInterner());
    }

    public SoyTypeRegistryBuilder addDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptorsToAdd) {
        this.descriptors.addAll(descriptorsToAdd);
        return this;
    }

    public SoyTypeRegistry build() {
        ImmutableList tmp = this.descriptors.build();
        ProtoFqnRegistryBuilder builder = new ProtoFqnRegistryBuilder((Iterable<Descriptors.GenericDescriptor>)tmp);
        SoyTypeRegistry base = SoyTypeRegistryBuilder.create();
        ProtoFqnTypeRegistry registry = (ProtoFqnTypeRegistry)builder.build(base);
        return new SoyTypeRegistryImpl(base, (ImmutableSet<Descriptors.FileDescriptor>)ImmutableSet.copyOf(builder.files.values()), registry);
    }

    private static class ProtoFqnTypeRegistry
    extends DelegatingProtoTypeRegistry {
        private final TypeInterner interner;
        private final ImmutableMap<String, Descriptors.GenericDescriptor> msgAndEnumFqnToDesc;
        private final ImmutableSetMultimap<String, Descriptors.FieldDescriptor> msgFqnToExts;

        public ProtoFqnTypeRegistry(SoyTypeRegistry delegate, ImmutableMap<String, Descriptors.GenericDescriptor> msgAndEnumFqnToDesc, ImmutableSetMultimap<String, Descriptors.FieldDescriptor> msgFqnToExts) {
            super(delegate.getProtoRegistry());
            this.interner = delegate;
            this.msgAndEnumFqnToDesc = msgAndEnumFqnToDesc;
            this.msgFqnToExts = msgFqnToExts;
        }

        @Override
        @Nullable
        public SoyType getProtoType(String protoFqn) {
            Descriptors.GenericDescriptor descriptor = (Descriptors.GenericDescriptor)this.msgAndEnumFqnToDesc.get((Object)protoFqn);
            if (descriptor instanceof Descriptors.EnumDescriptor) {
                return this.interner.getOrCreateProtoEnumType((Descriptors.EnumDescriptor)descriptor);
            }
            if (descriptor instanceof Descriptors.Descriptor) {
                return this.interner.getOrComputeProtoType((Descriptors.Descriptor)descriptor, name -> new SoyProtoType(this.interner, this, (Descriptors.Descriptor)descriptor, (Set<Descriptors.FieldDescriptor>)this.msgFqnToExts.get((Object)protoFqn)));
            }
            return super.getProtoType(protoFqn);
        }

        public ImmutableSet<String> getAllKeys() {
            return this.msgAndEnumFqnToDesc.keySet();
        }
    }

    private static abstract class DelegatingProtoTypeRegistry
    implements ProtoTypeRegistry {
        private final ProtoTypeRegistry delegate;

        protected DelegatingProtoTypeRegistry(ProtoTypeRegistry delegate) {
            this.delegate = delegate;
        }

        @Override
        public SoyType getProtoType(String protoFqn) {
            return this.delegate.getProtoType(protoFqn);
        }

        @Override
        public Iterable<String> getAllKeys() {
            return this.delegate.getAllKeys();
        }
    }

    static class SoyTypeRegistryImpl
    extends DelegatingSoyTypeRegistry {
        private final Supplier<Iterable<String>> allSortedTypeNames;
        private final Supplier<ImmutableMap<String, String>> prefixesToTypeNames;
        private final ImmutableSet<Descriptors.FileDescriptor> fileDescriptors;
        private final ProtoFqnTypeRegistry protoFqnRegistry;

        public SoyTypeRegistryImpl(SoyTypeRegistry delegate, ImmutableSet<Descriptors.FileDescriptor> fileDescriptors, ProtoFqnTypeRegistry protoFqnRegistry) {
            super(delegate);
            this.protoFqnRegistry = protoFqnRegistry;
            this.fileDescriptors = fileDescriptors;
            this.allSortedTypeNames = Suppliers.memoize(this::buildAllSortedTypeNames);
            this.prefixesToTypeNames = Suppliers.memoize(this::buildPrefixToTypeNamesMap);
        }

        @Override
        public ImmutableSet<Descriptors.FileDescriptor> getProtoDescriptors() {
            return this.fileDescriptors;
        }

        @Override
        public ProtoTypeRegistry getProtoRegistry() {
            return this.protoFqnRegistry;
        }

        @Override
        @Nullable
        public SoyType getType(String typeName) {
            SoyType type = super.getType(typeName);
            if (type != null) {
                return type;
            }
            return this.protoFqnRegistry.getProtoType(typeName);
        }

        @Override
        public String findTypeWithMatchingNamespace(String prefix) {
            return (String)this.prefixesToTypeNames.get().get((Object)(prefix + "."));
        }

        @Override
        public Iterable<String> getAllSortedTypeNames() {
            return this.allSortedTypeNames.get();
        }

        private Iterable<String> buildAllSortedTypeNames() {
            return Iterables.mergeSorted((Iterable)ImmutableList.of(super.getAllSortedTypeNames(), (Object)ImmutableList.sortedCopyOf(this.protoFqnRegistry.getAllKeys())), Comparator.naturalOrder());
        }

        private ImmutableMap<String, String> buildPrefixToTypeNamesMap() {
            HashMap<String, String> prefixesToTypeNamesBuilder = new HashMap<String, String>();
            Iterator<String> iterator = this.allSortedTypeNames.get().iterator();
            while (iterator.hasNext()) {
                String typeName;
                String prefix = typeName = iterator.next();
                int indexOfFirstDot = typeName.indexOf(".");
                if (indexOfFirstDot >= 0 && indexOfFirstDot < typeName.length() - 1) {
                    prefix = typeName.substring(0, indexOfFirstDot + 1);
                }
                prefixesToTypeNamesBuilder.putIfAbsent(prefix, typeName);
            }
            return ImmutableMap.copyOf(prefixesToTypeNamesBuilder);
        }
    }

    public static class ProtoFqnRegistryBuilder {
        private final ErrorReporter errorReporter = ErrorReporter.create((Map<String, SoyFileSupplier>)ImmutableMap.of());
        private final ImmutableSet<Descriptors.GenericDescriptor> inputs;
        private final Predicate<Descriptors.GenericDescriptor> alreadyVisitedKey;
        private final Predicate<Descriptors.GenericDescriptor> alreadyVisitedIdentity;
        private final Map<String, Descriptors.GenericDescriptor> msgAndEnumFqnToDesc = new HashMap<String, Descriptors.GenericDescriptor>();
        private final SetMultimap<String, Descriptors.FieldDescriptor> msgFqnToExts = HashMultimap.create();
        private final Map<String, Descriptors.FileDescriptor> files = new LinkedHashMap<String, Descriptors.FileDescriptor>();

        public ProtoFqnRegistryBuilder(Iterable<Descriptors.GenericDescriptor> inputs) {
            this.inputs = ImmutableSet.copyOf(inputs);
            HashSet visitedKeys = new HashSet();
            this.alreadyVisitedKey = d -> !visitedKeys.add(DescriptorKey.of(d));
            HashSet visitedDescriptors = new HashSet();
            this.alreadyVisitedIdentity = d -> !visitedDescriptors.add(d);
        }

        public ProtoTypeRegistry build(SoyTypeRegistry interner) {
            Set fileInputs = (Set)this.inputs.stream().filter(d -> d instanceof Descriptors.FileDescriptor).map(Descriptors.FileDescriptor.class::cast).collect(ImmutableSet.toImmutableSet());
            fileInputs.forEach(this::visitFile);
            this.inputs.stream().filter(d -> !fileInputs.contains(d.getFile())).forEach(this::visitGeneric);
            this.inputs.stream().map(Descriptors.GenericDescriptor::getFile).distinct().filter(d -> !fileInputs.contains(d)).forEach(this::visitFileForExtensions);
            if (this.errorReporter.hasErrors()) {
                throw new SoyInternalCompilerException((Iterable<SoyError>)this.errorReporter.getErrors(), null);
            }
            return new ProtoFqnTypeRegistry(interner, (ImmutableMap<String, Descriptors.GenericDescriptor>)ImmutableMap.copyOf(this.msgAndEnumFqnToDesc), (ImmutableSetMultimap<String, Descriptors.FieldDescriptor>)ImmutableSetMultimap.copyOf(this.msgFqnToExts));
        }

        private void visitGeneric(Descriptors.GenericDescriptor descriptor) {
            if (descriptor instanceof Descriptors.Descriptor) {
                this.visitMessage((Descriptors.Descriptor)descriptor);
            } else if (descriptor instanceof Descriptors.FieldDescriptor) {
                Descriptors.FieldDescriptor fd = (Descriptors.FieldDescriptor)descriptor;
                if (fd.isExtension()) {
                    this.visitExtension(fd);
                }
                this.visitField(fd);
            } else if (descriptor instanceof Descriptors.EnumDescriptor) {
                this.visitEnum((Descriptors.EnumDescriptor)descriptor);
            } else if (descriptor instanceof Descriptors.FileDescriptor) {
                throw new IllegalArgumentException();
            }
        }

        private void visitFile(Descriptors.FileDescriptor fd) {
            if (this.alreadyVisitedIdentity.test((Descriptors.GenericDescriptor)fd)) {
                return;
            }
            this.files.putIfAbsent(fd.getName(), fd);
            fd.getDependencies().forEach(this::visitFile);
            fd.getExtensions().forEach(this::visitExtension);
            fd.getMessageTypes().forEach(this::visitMessage);
            fd.getEnumTypes().forEach(this::visitEnum);
        }

        private void visitFileForExtensions(Descriptors.FileDescriptor fd) {
            this.files.putIfAbsent(fd.getName(), fd);
            fd.getDependencies().forEach(this::visitFileForExtensions);
            fd.getExtensions().forEach(this::visitExtension);
            fd.getMessageTypes().forEach(this::visitMessageForExtensions);
        }

        private void visitMessageForExtensions(Descriptors.Descriptor d) {
            d.getExtensions().forEach(this::visitExtension);
            d.getNestedTypes().forEach(this::visitMessageForExtensions);
        }

        private void visitMessage(Descriptors.Descriptor m) {
            if (this.alreadyVisitedIdentity.test((Descriptors.GenericDescriptor)m)) {
                return;
            }
            if (!this.alreadyVisitedKey.test((Descriptors.GenericDescriptor)m)) {
                this.putAndWarnCollision((Descriptors.GenericDescriptor)m);
            }
            m.getEnumTypes().forEach(this::visitEnum);
            m.getExtensions().forEach(this::visitExtension);
            m.getNestedTypes().forEach(this::visitMessage);
            m.getFields().forEach(this::visitField);
        }

        private void visitField(Descriptors.FieldDescriptor f) {
            if (f.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                this.visitMessage(f.getMessageType());
            }
            if (f.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                this.visitEnum(f.getEnumType());
            }
        }

        private void visitEnum(Descriptors.EnumDescriptor e) {
            if (this.alreadyVisitedKey.test((Descriptors.GenericDescriptor)e)) {
                return;
            }
            this.putAndWarnCollision((Descriptors.GenericDescriptor)e);
        }

        private void visitExtension(Descriptors.FieldDescriptor f) {
            Preconditions.checkArgument((boolean)f.isExtension());
            if (!ProtoUtils.shouldJsIgnoreField(f)) {
                this.msgFqnToExts.put((Object)f.getContainingType().getFullName(), (Object)f);
            }
        }

        private void putAndWarnCollision(Descriptors.GenericDescriptor d) {
            Descriptors.GenericDescriptor previous = this.msgAndEnumFqnToDesc.put(d.getFullName(), d);
            if (previous != null) {
                this.errorReporter.report(SourceLocation.UNKNOWN, PROTO_FQN_COLLISION, d.getFullName(), previous.getFile().getName(), d.getFile().getName());
            }
        }
    }

    @AutoValue
    static abstract class DescriptorKey {
        DescriptorKey() {
        }

        public static DescriptorKey of(Descriptors.GenericDescriptor d) {
            if (d instanceof Descriptors.FileDescriptor) {
                return new AutoValue_SoyTypeRegistryBuilder_DescriptorKey(d.getName(), "");
            }
            return new AutoValue_SoyTypeRegistryBuilder_DescriptorKey(d.getFile().getName(), d.getFullName());
        }

        abstract String filePath();

        abstract String fullName();
    }
}

