/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.SoyTypes;
import java.util.Objects;

public final class MapType
extends AbstractMapType {
    public static final MapType EMPTY_MAP = new MapType(null, null);
    public static final MapType ANY_MAP = new MapType(AnyType.getInstance(), AnyType.getInstance());
    public static final SoyErrorKind BAD_MAP_KEY_TYPE = SoyErrorKind.of("''{0}'' is not allowed as a map key type. Allowed map key types: bool, int, float, number, string, proto enum.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyType keyType;
    private final SoyType valueType;

    private MapType(SoyType keyType, SoyType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public static MapType of(SoyType keyType, SoyType valueType) {
        Preconditions.checkNotNull((Object)keyType);
        Preconditions.checkNotNull((Object)valueType);
        return new MapType(keyType, valueType);
    }

    public static boolean isAllowedKeyType(SoyType type) {
        switch (type.getKind()) {
            case BOOL: 
            case INT: 
            case FLOAT: 
            case STRING: 
            case PROTO_ENUM: {
                return true;
            }
        }
        return type == SoyTypes.NUMBER_TYPE;
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.MAP;
    }

    @Override
    public SoyType getKeyType() {
        return this.keyType;
    }

    @Override
    public SoyType getValueType() {
        return this.valueType;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType srcType) {
        if (srcType.getKind() == SoyType.Kind.MAP) {
            MapType srcMapType = (MapType)srcType;
            if (srcMapType == EMPTY_MAP) {
                return true;
            }
            if (this == EMPTY_MAP) {
                return false;
            }
            return this.keyType.isAssignableFrom(srcMapType.keyType) && this.valueType.isAssignableFrom(srcMapType.valueType);
        }
        return false;
    }

    @Override
    public String toString() {
        return "map<" + this.keyType + "," + this.valueType + ">";
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        builder.getMapBuilder().setKey(this.keyType.toProto()).setValue(this.valueType.toProto());
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            MapType otherMap = (MapType)other;
            return Objects.equals(otherMap.keyType, this.keyType) && Objects.equals(otherMap.valueType, this.valueType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.keyType, this.valueType);
    }

    @Override
    public <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

