/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class TemplateNodeBuilder<T extends TemplateNodeBuilder<T>> {
    private static final SoyErrorKind SOYDOC_PARAM = SoyErrorKind.of("SoyDoc params are not supported anymore. Use '{@param}' in the template header instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PARAM_NAMED_IJ = SoyErrorKind.of("Invalid param name ''ij'' (''ij'' is for injected data).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARAM_ALREADY_DECLARED = SoyErrorKind.of("''{0}'' already declared.", new SoyErrorKind.StyleAllowance[0]);
    protected final TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo;
    protected final ErrorReporter errorReporter;
    protected Integer id;
    protected String cmdText;
    private String templateName;
    private Identifier partialTemplateName;
    protected Visibility visibility;
    protected WhitespaceMode whitespaceMode = WhitespaceMode.JOIN;
    private ImmutableList<String> requiredCssNamespaces = ImmutableList.of();
    private String cssBaseNamespace;
    private TemplateContentKind contentKind;
    protected String soyDoc;
    protected String soyDocDesc;
    @Nullable
    protected ImmutableList<TemplateHeaderVarDefn> params;
    protected boolean strictHtmlDisabled;
    private List<CommandTagAttribute> attributes;
    SourceLocation sourceLocation;
    SourceLocation openTagLocation;
    protected static final ImmutableSet<String> COMMON_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"kind", (Object)"requirecss", (Object)"cssbase", (Object)"stricthtml", (Object)"whitespace");
    private static final Pattern NEWLINE = Pattern.compile("\\n|\\r\\n?");
    private static final Pattern SOY_DOC_START = Pattern.compile("^ [/][*][*] [\\ ]* \\r?\\n?", 4);
    private static final Pattern SOY_DOC_END = Pattern.compile("\\r?\\n? [\\ ]* [*][/] $", 4);

    protected TemplateNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.errorReporter = errorReporter;
    }

    public T setId(int id) {
        Preconditions.checkState((this.id == null ? 1 : 0) != 0);
        this.id = id;
        return this.self();
    }

    public List<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    public T setSourceLocation(SourceLocation location) {
        Preconditions.checkState((this.sourceLocation == null ? 1 : 0) != 0);
        this.sourceLocation = (SourceLocation)Preconditions.checkNotNull((Object)location);
        return this.self();
    }

    public T setOpenTagLocation(SourceLocation location) {
        Preconditions.checkState((this.openTagLocation == null ? 1 : 0) != 0);
        this.openTagLocation = (SourceLocation)Preconditions.checkNotNull((Object)location);
        return this.self();
    }

    public abstract T setCommandValues(Identifier var1, List<CommandTagAttribute> var2);

    protected void setCommonCommandValues(List<CommandTagAttribute> attrs) {
        this.attributes = attrs;
        TemplateContentKind kind = TemplateContentKind.HTML;
        for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            switch (name.identifier()) {
                case "kind": {
                    Optional<TemplateContentKind> parsedKind = attribute.valueAsTemplateContentKind(this.errorReporter);
                    if (parsedKind.orElse(null) == TemplateContentKind.HTML) {
                        this.errorReporter.report(attribute.getValueLocation(), CommandTagAttribute.EXPLICIT_DEFAULT_ATTRIBUTE, "kind", "html");
                    }
                    kind = parsedKind.orElse(TemplateContentKind.HTML);
                    break;
                }
                case "requirecss": {
                    this.setRequiredCssNamespaces(attribute.valueAsRequireCss(this.errorReporter));
                    break;
                }
                case "cssbase": {
                    this.setCssBaseNamespace(attribute.valueAsCssBase(this.errorReporter));
                    break;
                }
                case "stricthtml": {
                    this.strictHtmlDisabled = attribute.valueAsDisabled(this.errorReporter);
                    break;
                }
                case "whitespace": {
                    this.whitespaceMode = attribute.valueAsWhitespaceMode(this.errorReporter);
                    break;
                }
            }
        }
        this.setContentKind(kind);
    }

    public T setSoyDoc(String soyDoc, SourceLocation soyDocLocation) {
        Preconditions.checkState((this.soyDoc == null ? 1 : 0) != 0);
        Preconditions.checkState((this.cmdText != null ? 1 : 0) != 0);
        int paramOffset = soyDoc.indexOf("@param");
        if (paramOffset != -1) {
            this.errorReporter.report(new RawTextNode(-1, soyDoc, soyDocLocation).substringLocation(paramOffset, paramOffset + "@param".length()), SOYDOC_PARAM, new Object[0]);
        }
        this.soyDoc = soyDoc;
        Preconditions.checkArgument((soyDoc.startsWith("/**") && soyDoc.endsWith("*/") ? 1 : 0) != 0);
        this.soyDocDesc = TemplateNodeBuilder.cleanSoyDocHelper(soyDoc);
        return this.self();
    }

    public T addVarDefns(Iterable<? extends TemplateHeaderVarDefn> varDefns) {
        Preconditions.checkState((this.params == null ? 1 : 0) != 0);
        HashSet<String> seenVarDefns = new HashSet<String>();
        this.params = ImmutableList.copyOf(varDefns);
        for (TemplateHeaderVarDefn templateHeaderVarDefn : varDefns) {
            if (templateHeaderVarDefn.name().equals("ij")) {
                this.errorReporter.report(templateHeaderVarDefn.nameLocation(), INVALID_PARAM_NAMED_IJ, new Object[0]);
            }
            if (seenVarDefns.add(templateHeaderVarDefn.name())) continue;
            this.errorReporter.report(templateHeaderVarDefn.nameLocation(), PARAM_ALREADY_DECLARED, templateHeaderVarDefn.name());
        }
        return this.self();
    }

    public abstract TemplateNode build();

    protected void setContentKind(TemplateContentKind contentKind) {
        this.contentKind = contentKind;
    }

    Integer getId() {
        return this.id;
    }

    String getCmdText() {
        return this.cmdText;
    }

    String getSoyDoc() {
        return this.soyDoc;
    }

    String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    public TemplateContentKind getContentKind() {
        return this.contentKind;
    }

    public WhitespaceMode getWhitespaceMode() {
        return this.whitespaceMode;
    }

    protected ImmutableList<String> getRequiredCssNamespaces() {
        return (ImmutableList)Preconditions.checkNotNull(this.requiredCssNamespaces);
    }

    protected void setRequiredCssNamespaces(ImmutableList<String> requiredCssNamespaces) {
        this.requiredCssNamespaces = (ImmutableList)Preconditions.checkNotNull(requiredCssNamespaces);
    }

    protected String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    protected void setCssBaseNamespace(String cssBaseNamespace) {
        this.cssBaseNamespace = cssBaseNamespace;
    }

    protected final void setTemplateNames(String templateName, Identifier partialTemplateName) {
        this.templateName = (String)Preconditions.checkNotNull((Object)templateName);
        this.partialTemplateName = (Identifier)Preconditions.checkNotNull((Object)partialTemplateName);
    }

    protected boolean getStrictHtmlDisabled() {
        return this.strictHtmlDisabled;
    }

    protected String getTemplateName() {
        return this.templateName;
    }

    protected Identifier getPartialTemplateName() {
        return this.partialTemplateName;
    }

    protected abstract T self();

    private static String cleanSoyDocHelper(String soyDoc) {
        soyDoc = NEWLINE.matcher(soyDoc).replaceAll("\n");
        soyDoc = soyDoc.replace("@deprecated", "&#64;deprecated");
        soyDoc = SOY_DOC_START.matcher(soyDoc).replaceFirst("");
        soyDoc = SOY_DOC_END.matcher(soyDoc).replaceFirst("");
        ArrayList lines = Lists.newArrayList((Iterable)Splitter.on((Pattern)NEWLINE).split((CharSequence)soyDoc));
        TemplateNodeBuilder.removeCommonStartCharHelper(lines, ' ', true);
        if (TemplateNodeBuilder.removeCommonStartCharHelper(lines, '*', false) == 1) {
            TemplateNodeBuilder.removeCommonStartCharHelper(lines, ' ', true);
        }
        return CharMatcher.whitespace().trimTrailingFrom((CharSequence)Joiner.on((char)'\n').join((Iterable)lines));
    }

    private static int removeCommonStartCharHelper(List<String> lines, char charToRemove, boolean shouldRemoveMultiple) {
        int numCharsToRemove = 0;
        boolean isStillCounting = true;
        do {
            boolean areAllLinesEmpty = true;
            for (String line : lines) {
                if (line.length() == 0) continue;
                areAllLinesEmpty = false;
                if (line.length() > numCharsToRemove && line.charAt(numCharsToRemove) == charToRemove) continue;
                isStillCounting = false;
                break;
            }
            if (areAllLinesEmpty) {
                isStillCounting = false;
            }
            if (!isStillCounting) continue;
            ++numCharsToRemove;
        } while (isStillCounting && shouldRemoveMultiple);
        if (numCharsToRemove > 0) {
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (line.length() == 0) continue;
                lines.set(i, line.substring(numCharsToRemove));
            }
        }
        return numCharsToRemove;
    }
}

