/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import java.util.List;

public class TemplateBasicNodeBuilder
extends TemplateNodeBuilder<TemplateBasicNodeBuilder> {
    public TemplateBasicNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
    }

    @Override
    public TemplateBasicNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        this.setCommonCommandValues(attrs);
        this.visibility = Visibility.PUBLIC;
        block6: for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            if (COMMON_ATTRIBUTE_NAMES.contains((Object)name.identifier())) continue;
            switch (name.identifier()) {
                case "visibility": {
                    this.visibility = attribute.valueAsVisibility(this.errorReporter);
                    continue block6;
                }
            }
            this.errorReporter.report(name.location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name.identifier(), "template", ImmutableList.builder().add((Object)"visibility").addAll((Iterable)COMMON_ATTRIBUTE_NAMES).build());
        }
        this.setTemplateNames(this.soyFileHeaderInfo.getNamespace() + templateName.identifier(), templateName);
        return this;
    }

    @Override
    public TemplateBasicNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        return new TemplateBasicNode(this, this.soyFileHeaderInfo, this.visibility, (ImmutableList<TemplateHeaderVarDefn>)this.params);
    }

    @Override
    protected TemplateBasicNodeBuilder self() {
        return this;
    }
}

