/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.AbstractNodeVisitor;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public final class SoyTreeUtils {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    private SoyTreeUtils() {
    }

    @SafeVarargs
    public static boolean hasNodesOfType(Node node, Class<? extends Node> ... types) {
        class Visitor
        implements NodeVisitor<Node, VisitDirective> {
            boolean found;
            final /* synthetic */ Class[] val$types;

            Visitor(Class[] classArray) {
                this.val$types = classArray;
            }

            @Override
            public VisitDirective exec(Node node) {
                for (Class type : this.val$types) {
                    if (!type.isInstance(node)) continue;
                    this.found = true;
                    return VisitDirective.ABORT;
                }
                return VisitDirective.CONTINUE;
            }
        }
        Visitor v = new Visitor(types);
        SoyTreeUtils.visitAllNodes(node, v);
        return v.found;
    }

    public static boolean hasHtmlNodes(Node node) {
        return SoyTreeUtils.hasNodesOfType(node, HtmlOpenTagNode.class, HtmlCloseTagNode.class, HtmlCommentNode.class, HtmlAttributeNode.class, HtmlAttributeValueNode.class);
    }

    public static SoyNode nextSibling(SoyNode node) {
        return (SoyNode)SoyTreeUtils.nextSiblingNode(node);
    }

    public static Node nextSiblingNode(Node node) {
        ParentNode<?> parent = node.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.getChildIndex(node);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
        int nextIndex = index + 1;
        return parent.numChildren() > nextIndex ? (Node)parent.getChild(nextIndex) : null;
    }

    public static void visitAllNodes(Node node, NodeVisitor<? super Node, VisitDirective> visitor) {
        Node current;
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        queue.add(node);
        block5: while ((current = (Node)queue.poll()) != null) {
            switch (visitor.exec(current)) {
                case ABORT: {
                    return;
                }
                case CONTINUE: {
                    if (current instanceof ParentNode) {
                        queue.addAll(((ParentNode)current).getChildren());
                    }
                    if (!(current instanceof SoyNode.ExprHolderNode)) continue block5;
                    queue.addAll((Collection<Node>)((SoyNode.ExprHolderNode)current).getExprList());
                    continue block5;
                }
                case SKIP_CHILDREN: {
                    continue block5;
                }
            }
        }
    }

    public static <T extends Node> ImmutableList<T> getAllNodesOfType(Node rootSoyNode, Class<T> classObject) {
        return SoyTreeUtils.getAllMatchingNodesOfType(rootSoyNode, classObject, arg -> true);
    }

    public static <T extends Node> ImmutableList<T> getAllMatchingNodesOfType(Node rootSoyNode, final Class<T> classObject, final Predicate<T> filter) {
        final ImmutableList.Builder matchedNodesBuilder = ImmutableList.builder();
        final boolean exploreExpressions = ExprNode.class.isAssignableFrom(classObject);
        SoyTreeUtils.visitAllNodes(rootSoyNode, (NodeVisitor<? super Node, VisitDirective>)new NodeVisitor<Node, VisitDirective>(){

            @Override
            public VisitDirective exec(Node node) {
                Node typedNode;
                if (classObject.isInstance(node) && filter.test(typedNode = (Node)classObject.cast(node))) {
                    matchedNodesBuilder.add((Object)typedNode);
                }
                if (!exploreExpressions && node instanceof ExprNode) {
                    return VisitDirective.SKIP_CHILDREN;
                }
                return VisitDirective.CONTINUE;
            }
        });
        return matchedNodesBuilder.build();
    }

    public static ImmutableList<FunctionNode> getAllFunctionInvocations(Node rootSoyNode, SoyFunction functionToMatch) {
        return SoyTreeUtils.getAllMatchingNodesOfType(rootSoyNode, FunctionNode.class, function -> functionToMatch.equals(function.getSoyFunction()));
    }

    public static StringBuilder buildAstString(SoyNode.ParentSoyNode<?> node, int indent, StringBuilder sb) {
        for (SoyNode child : node.getChildren()) {
            sb.append(Strings.repeat((String)"  ", (int)indent)).append((Object)child.getKind()).append('\n');
            if (!(child instanceof SoyNode.ParentSoyNode)) continue;
            SoyTreeUtils.buildAstString((SoyNode.ParentSoyNode)child, indent + 1, sb);
        }
        return sb;
    }

    public static StringBuilder buildAstStringWithPreview(SoyNode.ParentSoyNode<?> node, int indent, StringBuilder sb) {
        for (SoyNode child : node.getChildren()) {
            sb.append(Strings.repeat((String)"  ", (int)indent)).append((Object)child.getKind()).append(": ").append(child.toSourceString()).append('\n');
            if (!(child instanceof SoyNode.ParentSoyNode)) continue;
            SoyTreeUtils.buildAstString((SoyNode.ParentSoyNode)child, indent + 1, sb);
        }
        return sb;
    }

    public static StringBuilder buildAstStringWithPreview(ExprNode.ParentExprNode node, int indent, StringBuilder sb) {
        for (ExprNode child : node.getChildren()) {
            sb.append(Strings.repeat((String)"  ", (int)indent)).append((Object)child.getKind()).append(": ").append(child.toSourceString()).append('\n');
            if (!(child instanceof ExprNode.ParentExprNode)) continue;
            SoyTreeUtils.buildAstStringWithPreview((ExprNode.ParentExprNode)child, indent + 1, sb);
        }
        return sb;
    }

    public static <R> void execOnAllV2Exprs(SoyNode node, final AbstractNodeVisitor<ExprNode, R> exprNodeVisitor) {
        SoyTreeUtils.visitAllNodes(node, (NodeVisitor<? super Node, VisitDirective>)new NodeVisitor<Node, VisitDirective>(){

            @Override
            public VisitDirective exec(Node node) {
                if (node instanceof SoyNode.ExprHolderNode) {
                    for (ExprRootNode expr : ((SoyNode.ExprHolderNode)node).getExprList()) {
                        exprNodeVisitor.exec(expr);
                    }
                } else if (node instanceof ExprNode) {
                    return VisitDirective.SKIP_CHILDREN;
                }
                return VisitDirective.CONTINUE;
            }
        });
    }

    public static <T extends SoyNode> T cloneWithNewIds(T origNode, IdGenerator nodeIdGen) {
        SoyNode clone = origNode.copy(new CopyState());
        new GenNewIdsVisitor(nodeIdGen).exec(clone);
        return (T)clone;
    }

    public static <T extends SoyNode> List<T> cloneListWithNewIds(List<T> origNodes, IdGenerator nodeIdGen) {
        Preconditions.checkNotNull(origNodes);
        ArrayList<SoyNode> clones = new ArrayList<SoyNode>(origNodes.size());
        for (SoyNode origNode : origNodes) {
            SoyNode clone = origNode.copy(new CopyState());
            new GenNewIdsVisitor(nodeIdGen).exec(clone);
            clones.add(clone);
        }
        return clones;
    }

    public static boolean isDescendantOf(Node node, Node ancestor) {
        if (node instanceof ExprNode) {
            ExprNode nodeAsExpr = (ExprNode)node;
            if (ancestor instanceof ExprNode) {
                return SoyTreeUtils.isDescendantOf(nodeAsExpr, (ExprNode)ancestor);
            }
            return SoyTreeUtils.isDescendantOf(nodeAsExpr, (SoyNode)ancestor);
        }
        if (ancestor instanceof ExprNode) {
            return false;
        }
        return SoyTreeUtils.isDescendantOf((SoyNode)node, (SoyNode)ancestor);
    }

    public static boolean isDescendantOf(SoyNode node, SoyNode ancestor) {
        return SoyTreeUtils.doIsDescendantOf(node, ancestor);
    }

    public static boolean isDescendantOf(ExprNode node, ExprNode ancestor) {
        return SoyTreeUtils.doIsDescendantOf(node, ancestor);
    }

    public static boolean isDescendantOf(ExprNode node, SoyNode ancestor) {
        while (node.getParent() != null) {
            node = node.getParent();
        }
        for (SoyNode.ExprHolderNode holder : SoyTreeUtils.getAllNodesOfType(ancestor, SoyNode.ExprHolderNode.class)) {
            for (ExprRootNode root : holder.getExprList()) {
                if (root != node) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean doIsDescendantOf(Node node, Node ancestor) {
        while (node != null) {
            if (ancestor == node) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static String toSourceString(List<? extends Node> nodes) {
        ArrayList<String> strings = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            strings.add(node.toSourceString());
        }
        return COMMA_JOINER.join(strings);
    }

    public static boolean isConstantExpr(ExprNode rootSoyNode) {
        return SoyTreeUtils.getNonConstantChildren(rootSoyNode, false).isEmpty();
    }

    public static ImmutableList<ExprNode> getNonConstantChildren(ExprNode rootSoyNode) {
        return SoyTreeUtils.getNonConstantChildren(rootSoyNode, true);
    }

    private static ImmutableList<ExprNode> getNonConstantChildren(ExprNode rootSoyNode, boolean all) {
        class ConstantNodeVisitor
        implements NodeVisitor<Node, VisitDirective> {
            ImmutableList.Builder<ExprNode> nonConstantExpressions = ImmutableList.builder();
            final /* synthetic */ boolean val$all;

            ConstantNodeVisitor(boolean bl) {
                this.val$all = bl;
            }

            @Override
            public VisitDirective exec(Node node) {
                ExprNode expr = (ExprNode)node;
                switch (expr.getKind()) {
                    case VAR_REF_NODE: {
                        this.nonConstantExpressions.add((Object)expr);
                        return this.val$all ? VisitDirective.CONTINUE : VisitDirective.ABORT;
                    }
                    case FUNCTION_NODE: {
                        FunctionNode fn = (FunctionNode)node;
                        if (fn.isPure()) {
                            return VisitDirective.CONTINUE;
                        }
                        this.nonConstantExpressions.add((Object)expr);
                        return this.val$all ? VisitDirective.CONTINUE : VisitDirective.ABORT;
                    }
                }
                return VisitDirective.CONTINUE;
            }
        }
        ConstantNodeVisitor visitor = new ConstantNodeVisitor(all);
        SoyTreeUtils.visitAllNodes(rootSoyNode, visitor);
        return visitor.nonConstantExpressions.build();
    }

    public static HtmlTagNode getNodeAsHtmlTagNode(SoyNode node, boolean openTag) {
        MsgHtmlTagNode msgHtmlTagNode;
        MsgPlaceholderNode placeholderNode;
        SoyNode.Kind tagKind;
        SoyNode.Kind kind = tagKind = openTag ? SoyNode.Kind.HTML_OPEN_TAG_NODE : SoyNode.Kind.HTML_CLOSE_TAG_NODE;
        if (node.getKind() == tagKind) {
            return (HtmlTagNode)node;
        }
        if (node.getKind() == SoyNode.Kind.MSG_PLACEHOLDER_NODE && (placeholderNode = (MsgPlaceholderNode)node).numChildren() == 1 && ((SoyNode.StandaloneNode)placeholderNode.getChild(0)).getKind() == SoyNode.Kind.MSG_HTML_TAG_NODE && (msgHtmlTagNode = (MsgHtmlTagNode)placeholderNode.getChild(0)).numChildren() == 1 && ((SoyNode.StandaloneNode)msgHtmlTagNode.getChild(0)).getKind() == tagKind) {
            return (HtmlTagNode)msgHtmlTagNode.getChild(0);
        }
        return null;
    }

    private static class GenNewIdsExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final IdGenerator nodeIdGen;

        public GenNewIdsExprVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitListComprehensionNode(ListComprehensionNode node) {
            node.setNodeId(this.nodeIdGen.genId());
            this.visitChildren(node);
        }
    }

    private static class GenNewIdsVisitor
    extends AbstractNodeVisitor<SoyNode, Void> {
        private IdGenerator nodeIdGen;

        public GenNewIdsVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visit(SoyNode node) {
            node.setId(this.nodeIdGen.genId());
            if (node instanceof SoyNode.ExprHolderNode) {
                SoyNode.ExprHolderNode exprHolderNode = (SoyNode.ExprHolderNode)node;
                for (ExprRootNode expr : exprHolderNode.getExprList()) {
                    new GenNewIdsExprVisitor(this.nodeIdGen).exec(expr);
                }
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    public static enum VisitDirective {
        SKIP_CHILDREN,
        ABORT,
        CONTINUE;

    }
}

