/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.MessagePlaceholder;

public interface SoyNode
extends Node {
    public Kind getKind();

    public void setId(int var1);

    public int getId();

    public ParentSoyNode<?> getParent();

    @Override
    public SoyNode copy(CopyState var1);

    public static interface MsgPlaceholderInitialNode
    extends StandaloneNode {
        public MessagePlaceholder getPlaceholder();

        public SamenessKey genSamenessKey();

        public static final class IdentitySamenessKey
        implements SamenessKey {
            private SoyNode node;

            IdentitySamenessKey(SoyNode node) {
                this.node = (SoyNode)Preconditions.checkNotNull((Object)node);
            }

            private IdentitySamenessKey(IdentitySamenessKey orig, CopyState copyState) {
                this.node = orig.node;
                copyState.registerRefListener(orig.node, newNode -> {
                    this.node = newNode;
                });
            }

            @Override
            public IdentitySamenessKey copy(CopyState copyState) {
                return new IdentitySamenessKey(this, copyState);
            }

            public boolean equals(Object other) {
                return other instanceof IdentitySamenessKey && ((IdentitySamenessKey)other).node == this.node;
            }

            public int hashCode() {
                return System.identityHashCode(this.node);
            }
        }

        public static interface SamenessKey {
            public SamenessKey copy(CopyState var1);
        }
    }

    public static interface MsgBlockNode
    extends BlockNode {
    }

    public static interface MsgSubstUnitNode
    extends StandaloneNode {
        @Override
        public MsgBlockNode getParent();

        public MessagePlaceholder getPlaceholder();

        public boolean shouldUseSameVarNameAs(MsgSubstUnitNode var1, ExprEquivalence var2);
    }

    public static interface ExprHolderNode
    extends SoyNode {
        public ImmutableList<ExprRootNode> getExprList();
    }

    public static interface LocalVarInlineNode
    extends LocalVarNode,
    StandaloneNode {
    }

    public static interface LocalVarBlockNode
    extends LocalVarNode,
    BlockNode {
    }

    public static interface LocalVarNode
    extends SoyNode {
        public String getVarName();

        public VarDefn getVar();
    }

    public static interface ConditionalBlockNode
    extends BlockNode {
    }

    public static interface StatementNode
    extends StandaloneNode {
    }

    public static interface RenderUnitNode
    extends BlockCommandNode {
        public SanitizedContentKind getContentKind();
    }

    public static interface BlockCommandNode
    extends CommandNode,
    BlockNode {
        public SourceLocation getOpenTagLocation();
    }

    public static interface CommandNode
    extends SoyNode {
        public String getCommandName();

        public String getCommandText();
    }

    public static interface BlockNode
    extends ParentSoyNode<StandaloneNode> {
    }

    public static interface StandaloneNode
    extends SoyNode {
        @Override
        public ParentSoyNode<StandaloneNode> getParent();

        @Override
        public StandaloneNode copy(CopyState var1);
    }

    public static interface SplitLevelTopNode<N extends SoyNode>
    extends ParentSoyNode<N> {
    }

    public static interface ParentSoyNode<N extends SoyNode>
    extends SoyNode,
    ParentNode<N> {
    }

    public static enum Kind {
        SOY_FILE_SET_NODE,
        SOY_FILE_NODE,
        IMPORT_NODE,
        TEMPLATE_BASIC_NODE,
        TEMPLATE_DELEGATE_NODE,
        TEMPLATE_ELEMENT_NODE,
        RAW_TEXT_NODE,
        MSG_FALLBACK_GROUP_NODE,
        MSG_NODE,
        MSG_PLURAL_NODE,
        MSG_PLURAL_CASE_NODE,
        MSG_PLURAL_DEFAULT_NODE,
        MSG_SELECT_NODE,
        MSG_SELECT_CASE_NODE,
        MSG_SELECT_DEFAULT_NODE,
        MSG_PLACEHOLDER_NODE,
        MSG_HTML_TAG_NODE,
        PRINT_NODE,
        PRINT_DIRECTIVE_NODE,
        LET_VALUE_NODE,
        LET_CONTENT_NODE,
        IF_NODE,
        IF_COND_NODE,
        IF_ELSE_NODE,
        SWITCH_NODE,
        SWITCH_CASE_NODE,
        SWITCH_DEFAULT_NODE,
        FOR_NODE,
        FOR_NONEMPTY_NODE,
        FOR_IFEMPTY_NODE,
        CALL_BASIC_NODE,
        CALL_DELEGATE_NODE,
        CALL_PARAM_VALUE_NODE,
        CALL_PARAM_CONTENT_NODE,
        HTML_OPEN_TAG_NODE,
        HTML_CLOSE_TAG_NODE,
        HTML_ATTRIBUTE_NODE,
        HTML_ATTRIBUTE_VALUE_NODE,
        HTML_COMMENT_NODE,
        KEY_NODE,
        SKIP_NODE,
        VE_LOG_NODE,
        LOG_NODE,
        DEBUGGER_NODE;

    }
}

