/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.Comment;
import com.google.template.soy.soytree.DelPackageDeclaration;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyTypeRegistry;
import javax.annotation.Nullable;

public final class SoyFileNode
extends AbstractParentSoyNode<SoyNode>
implements SoyNode.SplitLevelTopNode<SoyNode> {
    @Nullable
    private final DelPackageDeclaration delPackage;
    private final NamespaceDeclaration namespaceDeclaration;
    private final ImmutableList<AliasDeclaration> aliasDeclarations;
    private final TemplateNode.SoyFileHeaderInfo headerInfo;
    private final ImmutableList<Comment> comments;
    private ImportsContext importsContext;

    public SoyFileNode(int id, SourceLocation sourceLocation, NamespaceDeclaration namespaceDeclaration, TemplateNode.SoyFileHeaderInfo headerInfo, ImmutableList<Comment> comments) {
        super(id, sourceLocation);
        this.headerInfo = headerInfo;
        this.delPackage = headerInfo.getDelPackage();
        this.namespaceDeclaration = namespaceDeclaration;
        this.aliasDeclarations = headerInfo.getAliases();
        this.comments = comments;
        this.importsContext = new ImportsContext();
    }

    private SoyFileNode(SoyFileNode orig, CopyState copyState) {
        super(orig, copyState);
        this.delPackage = orig.delPackage;
        this.namespaceDeclaration = orig.namespaceDeclaration.copy(copyState);
        this.aliasDeclarations = orig.aliasDeclarations;
        this.headerInfo = orig.headerInfo.copy();
        this.comments = orig.comments;
        this.importsContext = new ImportsContext();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SOY_FILE_NODE;
    }

    public ImmutableList<CommandTagAttribute> getNamespaceAttributes() {
        return this.namespaceDeclaration.attrs;
    }

    @Nullable
    public String getDelPackageName() {
        return this.delPackage == null ? null : this.delPackage.name().identifier();
    }

    @Nullable
    public DelPackageDeclaration getDelPackage() {
        return this.delPackage;
    }

    public String getNamespace() {
        return this.namespaceDeclaration.getNamespace();
    }

    public NamespaceDeclaration getNamespaceDeclaration() {
        return this.namespaceDeclaration;
    }

    public ImmutableList<String> getRequiredCssNamespaces() {
        return this.namespaceDeclaration.getRequiredCssNamespaces();
    }

    public ImmutableList<String> getRequiredCssPaths() {
        return this.namespaceDeclaration.getRequiredCssPaths();
    }

    public ImmutableList<String> getRequireCss() {
        return new ImmutableList.Builder().addAll(this.getRequiredCssNamespaces()).addAll(this.getRequiredCssPaths()).build();
    }

    @Nullable
    public String getCssBaseNamespace() {
        return this.namespaceDeclaration.getCssBaseNamespace();
    }

    @Nullable
    public String getCssPrefix() {
        return this.namespaceDeclaration.getCssPrefix();
    }

    public ImmutableList<AliasDeclaration> getAliasDeclarations() {
        return this.aliasDeclarations;
    }

    public String getFilePath() {
        return this.getSourceLocation().getFilePath();
    }

    public ImmutableList<TemplateNode> getTemplates() {
        return (ImmutableList)this.getChildren().stream().filter(c -> c instanceof TemplateNode).map(c -> (TemplateNode)c).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<ImportNode> getImports() {
        return (ImmutableList)this.getChildren().stream().filter(c -> c instanceof ImportNode).map(c -> (ImportNode)c).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    public String getFileName() {
        return this.getSourceLocation().getFileName();
    }

    public ImmutableList<Comment> getComments() {
        return this.comments;
    }

    public Identifier resolveAlias(Identifier identifier) {
        Preconditions.checkState((this.importsContext != null ? 1 : 0) != 0, (Object)"Called resolveAlias() before ImportsPass was run");
        return this.importsContext.resolveAlias(identifier, this.headerInfo);
    }

    public boolean aliasUsed(String alias) {
        return this.headerInfo.aliasUsed(alias);
    }

    public TemplateNode.SoyFileHeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public SoyTypeRegistry getSoyTypeRegistry() {
        Preconditions.checkState((this.importsContext != null ? 1 : 0) != 0, (Object)"Called getSoyTypeRegistry() before ResolveProtoImportsPass was run.");
        return this.importsContext.getTypeRegistry();
    }

    public ImportsContext.ImportsTemplateRegistry getTemplateRegistry() {
        Preconditions.checkState((this.importsContext != null ? 1 : 0) != 0, (Object)"Called getTemplateRegistry() before ResolveTemplateImportsPass was run.");
        return this.importsContext.getTemplateRegistry();
    }

    public boolean hasTemplateRegistry() {
        return this.importsContext.hasTemplateRegistry();
    }

    public ImportsContext getImportsContext() {
        return this.importsContext;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.delPackage != null) {
            sb.append("{delpackage ").append(this.delPackage.name()).append("}\n");
        }
        sb.append(this.namespaceDeclaration.toSourceString());
        if (!this.aliasDeclarations.isEmpty()) {
            sb.append("\n");
            for (AliasDeclaration aliasDeclaration : this.aliasDeclarations) {
                String alias = aliasDeclaration.alias().identifier();
                String aliasNamespace = aliasDeclaration.namespace().identifier();
                if (aliasNamespace.equals(alias) || aliasNamespace.endsWith("." + alias)) {
                    sb.append("{alias ").append(aliasNamespace).append("}\n");
                    continue;
                }
                sb.append("{alias ").append(aliasNamespace).append(" as ").append(alias).append("}\n");
            }
        }
        for (SoyNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(child.toSourceString());
        }
        return sb.toString();
    }

    @Override
    public SoyFileSetNode getParent() {
        return (SoyFileSetNode)super.getParent();
    }

    @Override
    public SoyFileNode copy(CopyState copyState) {
        return new SoyFileNode(this, copyState);
    }
}

