/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MessagePlaceholder;
import com.google.template.soy.soytree.MsgSubstUnitPlaceholderNameUtils;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class PrintNode
extends AbstractParentCommandNode<PrintDirectiveNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<PrintDirectiveNode>,
HtmlContext.HtmlContextHolder,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode,
CommandTagAttribute.CommandTagAttributesHolder {
    private static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final boolean isImplicit;
    private final ExprRootNode expr;
    private final List<CommandTagAttribute> attributes;
    private final MessagePlaceholder placeholder;
    @Nullable
    private HtmlContext htmlContext;

    public PrintNode(int id, SourceLocation location, boolean isImplicit, ExprNode expr, Iterable<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, isImplicit ? "" : "print");
        this.isImplicit = isImplicit;
        this.expr = new ExprRootNode(expr);
        this.attributes = ImmutableList.copyOf(attributes);
        SourceLocation phNameLocation = null;
        String phName = null;
        Optional<String> phExample = Optional.empty();
        block8: for (CommandTagAttribute attribute : attributes) {
            switch (attribute.getName().identifier()) {
                case "phname": {
                    phNameLocation = attribute.getValueLocation();
                    phName = MessagePlaceholder.validatePlaceholderName(attribute.getValue(), phNameLocation, errorReporter);
                    continue block8;
                }
                case "phex": {
                    phExample = Optional.ofNullable(MessagePlaceholder.validatePlaceholderExample(attribute.getValue(), attribute.getValueLocation(), errorReporter));
                    continue block8;
                }
            }
            errorReporter.report(attribute.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, attribute.getName().identifier(), "print", ImmutableList.of((Object)"phname", (Object)"phex"));
        }
        this.placeholder = phName == null ? MessagePlaceholder.create(MsgSubstUnitPlaceholderNameUtils.genNaiveBaseNameForExpr(expr, FALLBACK_BASE_PLACEHOLDER_NAME), phExample) : MessagePlaceholder.createWithUserSuppliedName(BaseUtils.convertToUpperUnderscore(phName), phName, phNameLocation, phExample);
    }

    private PrintNode(PrintNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isImplicit = orig.isImplicit;
        this.expr = orig.expr.copy(copyState);
        this.placeholder = orig.placeholder;
        this.htmlContext = orig.htmlContext;
        this.attributes = (List)orig.attributes.stream().map(c -> c.copy(copyState)).collect(ImmutableList.toImmutableList());
        copyState.updateRefs(orig, this);
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.getSourceLocation();
    }

    @Override
    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlContextVisitor or InferenceEngine."));
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_NODE;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public boolean hasUserSpecifiedPrintDirectives() {
        return this.getChildren().stream().anyMatch(pd -> !pd.isSynthetic());
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    public List<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public MessagePlaceholder getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public SoyNode.MsgPlaceholderInitialNode.SamenessKey genSamenessKey() {
        return new SamenessKeyImpl(this);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public String getCommandText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr.toSourceString());
        for (PrintDirectiveNode child : this.getChildren()) {
            sb.append(' ').append(child.toSourceString());
        }
        this.placeholder.userSuppliedName().ifPresent(phname -> sb.append(" phname=\"").append((String)phname).append('\"'));
        this.placeholder.example().ifPresent(phex -> sb.append(" phex=\"").append((String)phex).append('\"'));
        return sb.toString();
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public PrintNode copy(CopyState copyState) {
        return new PrintNode(this, copyState);
    }

    static final class PrintEquivalence
    extends Equivalence<PrintNode> {
        private static final PrintEquivalence INSTANCE = new PrintEquivalence();

        PrintEquivalence() {
        }

        static PrintEquivalence get() {
            return INSTANCE;
        }

        protected boolean doEquivalent(PrintNode a, PrintNode b) {
            ExprEquivalence exprEquivalence = new ExprEquivalence();
            if (!exprEquivalence.equivalent(a.getExpr(), b.getExpr())) {
                return false;
            }
            List aDirectives = a.getChildren();
            List bDirectives = b.getChildren();
            if (aDirectives.size() != bDirectives.size()) {
                return false;
            }
            for (int i = 0; i < aDirectives.size(); ++i) {
                ImmutableList<ExprRootNode> two;
                PrintDirectiveNode aDirective = (PrintDirectiveNode)aDirectives.get(i);
                PrintDirectiveNode bDirective = (PrintDirectiveNode)bDirectives.get(i);
                if (!aDirective.getName().equals(bDirective.getName())) {
                    return false;
                }
                ImmutableList<ExprRootNode> one = aDirective.getExprList();
                if (exprEquivalence.equivalent((List<ExprNode>)one, (List<ExprNode>)(two = bDirective.getExprList()))) continue;
                return false;
            }
            return true;
        }

        protected int doHash(PrintNode t) {
            ExprEquivalence exprEquivalence = new ExprEquivalence();
            int hc = exprEquivalence.hash(t.getExpr());
            for (PrintDirectiveNode child : t.getChildren()) {
                ImmutableList<ExprRootNode> list = child.getExprList();
                hc = 31 * hc + child.getName().hashCode();
                hc = 31 * hc + exprEquivalence.hash((List<ExprNode>)list);
            }
            return hc;
        }
    }

    private static final class SamenessKeyImpl
    implements SoyNode.MsgPlaceholderInitialNode.SamenessKey {
        PrintNode node;

        SamenessKeyImpl(PrintNode node) {
            this.node = (PrintNode)Preconditions.checkNotNull((Object)node);
        }

        SamenessKeyImpl(SamenessKeyImpl orig, CopyState copyState) {
            this.node = orig.node;
            copyState.registerRefListener(orig.node, newNode -> {
                this.node = newNode;
            });
        }

        @Override
        public SamenessKeyImpl copy(CopyState copyState) {
            return new SamenessKeyImpl(this, copyState);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SamenessKeyImpl)) {
                return false;
            }
            PrintNode other = ((SamenessKeyImpl)obj).node;
            return Objects.equals(this.node.getPlaceholder().userSuppliedName(), other.getPlaceholder().userSuppliedName()) && PrintEquivalence.get().equivalent(this.node, other);
        }

        public int hashCode() {
            return Objects.hash(this.node.getPlaceholder().userSuppliedName(), PrintEquivalence.get().wrap(this.node));
        }
    }
}

