/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

public final class PrintDirectiveNode
extends AbstractSoyNode
implements SoyNode.ExprHolderNode {
    private final Identifier name;
    private SoyPrintDirective printDirective;
    private SoySourceFunction printDirectiveFunction;
    private final ImmutableList<ExprRootNode> args;
    private final boolean isSynthetic;

    public static PrintDirectiveNode createSyntheticNode(int id, Identifier name, SourceLocation location, SoyPrintDirective printDirective) {
        PrintDirectiveNode node = new PrintDirectiveNode(id, name, location, (ImmutableList<ExprNode>)ImmutableList.of(), true);
        node.setPrintDirective(printDirective);
        return node;
    }

    public PrintDirectiveNode(int id, Identifier name, SourceLocation location, ImmutableList<ExprNode> args) {
        this(id, name, location, args, false);
    }

    private PrintDirectiveNode(int id, Identifier name, SourceLocation location, ImmutableList<ExprNode> args, boolean isSynthetic) {
        super(id, location);
        this.name = name;
        this.args = ExprRootNode.wrap(args);
        this.isSynthetic = isSynthetic;
    }

    private PrintDirectiveNode(PrintDirectiveNode orig, CopyState copyState) {
        super(orig, copyState);
        ArrayList tempArgs = Lists.newArrayListWithCapacity((int)orig.args.size());
        for (ExprRootNode origArg : orig.args) {
            tempArgs.add(origArg.copy(copyState));
        }
        this.name = orig.name;
        this.args = ImmutableList.copyOf((Collection)tempArgs);
        this.printDirective = orig.printDirective;
        this.printDirectiveFunction = orig.printDirectiveFunction;
        this.isSynthetic = orig.isSynthetic;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_DIRECTIVE_NODE;
    }

    public String getName() {
        return this.name.identifier();
    }

    public SourceLocation getNameLocation() {
        return this.name.location();
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public ImmutableList<ExprRootNode> getArgs() {
        return this.getExprList();
    }

    @Override
    public String toSourceString() {
        return this.args.isEmpty() ? this.getName() : this.getName() + ":" + SoyTreeUtils.toSourceString(this.args);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return this.args;
    }

    @Override
    public PrintDirectiveNode copy(CopyState copyState) {
        return new PrintDirectiveNode(this, copyState);
    }

    public SoyPrintDirective getPrintDirective() {
        Preconditions.checkState((this.printDirective != null ? 1 : 0) != 0, (Object)"setPrintDirective hasn't been called yet");
        return this.printDirective;
    }

    @Nullable
    public SoySourceFunction getPrintDirectiveFunction() {
        return this.printDirectiveFunction;
    }

    public void setPrintDirective(SoyPrintDirective printDirective) {
        Preconditions.checkState((this.printDirective == null ? 1 : 0) != 0, (Object)"setPrintDirective has already been called");
        Preconditions.checkArgument((boolean)this.name.identifier().equals(printDirective.getName()));
        this.printDirective = (SoyPrintDirective)Preconditions.checkNotNull((Object)printDirective);
    }

    public void setPrintDirectiveFunction(SoySourceFunction sourceFunction) {
        Preconditions.checkState((this.printDirectiveFunction == null ? 1 : 0) != 0, (Object)"setPrintDirectiveFunction has already been called");
        this.printDirectiveFunction = (SoySourceFunction)Preconditions.checkNotNull((Object)sourceFunction);
    }
}

