/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class MsgFallbackGroupNode
extends AbstractParentSoyNode<MsgNode>
implements HtmlContext.HtmlContextHolder,
SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<MsgNode>,
SoyNode.StatementNode {
    private ImmutableList<SoyPrintDirective> escapingDirectiveNames = ImmutableList.of();
    @Nullable
    private HtmlContext htmlContext;

    public MsgFallbackGroupNode(int id, SourceLocation sourceLocation) {
        super(id, sourceLocation);
    }

    private MsgFallbackGroupNode(MsgFallbackGroupNode orig, CopyState copyState) {
        super(orig, copyState);
        this.escapingDirectiveNames = orig.escapingDirectiveNames;
        this.htmlContext = orig.htmlContext;
    }

    @Override
    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlTransformVisitor"));
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_FALLBACK_GROUP_NODE;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        sb.append("{/msg}");
        return sb.toString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    public boolean hasFallbackMsg() {
        return this.numChildren() > 1;
    }

    public MsgNode getMsg() {
        return (MsgNode)this.getChild(0);
    }

    public MsgNode getFallbackMsg() {
        Preconditions.checkState((boolean)this.hasFallbackMsg(), (Object)"This node doesn't have a {fallbackmsg}");
        return (MsgNode)this.getChild(1);
    }

    @Override
    public MsgFallbackGroupNode copy(CopyState copyState) {
        return new MsgFallbackGroupNode(this, copyState);
    }

    public void setEscapingDirectives(ImmutableList<SoyPrintDirective> escapingDirectiveNames) {
        this.escapingDirectiveNames = escapingDirectiveNames;
    }

    public ImmutableList<SoyPrintDirective> getEscapingDirectives() {
        return this.escapingDirectiveNames;
    }
}

