/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AutoValue_MessagePlaceholder;
import com.google.template.soy.soytree.AutoValue_MessagePlaceholder_Summary;
import java.util.Optional;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class MessagePlaceholder {
    public static final String PHNAME_ATTR = "phname";
    public static final String PHEX_ATTR = "phex";
    private static final SoyErrorKind INVALID_PHNAME_ATTRIBUTE = SoyErrorKind.of("''phname'' is not a valid identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PHNAME_EXAMPLE = SoyErrorKind.of("Placeholder examples must be non-empty.", new SoyErrorKind.StyleAllowance[0]);

    @Nullable
    public static String validatePlaceholderName(String name, SourceLocation location, ErrorReporter reporter) {
        if (BaseUtils.isIdentifier(name)) {
            return name;
        }
        reporter.report(location, INVALID_PHNAME_ATTRIBUTE, new Object[0]);
        return null;
    }

    @Nullable
    static String validatePlaceholderExample(String example, SourceLocation location, ErrorReporter reporter) {
        if (!example.isEmpty()) {
            return example;
        }
        reporter.report(location, INVALID_PHNAME_EXAMPLE, new Object[0]);
        return null;
    }

    public static MessagePlaceholder create(String name) {
        return MessagePlaceholder.create(name, Optional.empty());
    }

    public static MessagePlaceholder create(String name, Optional<String> example) {
        return new AutoValue_MessagePlaceholder(Summary.create(name, example), Optional.empty(), Optional.empty());
    }

    public static MessagePlaceholder createWithUserSuppliedName(String userSuppliedName, SourceLocation userSuppliedNameLocation) {
        return MessagePlaceholder.createWithUserSuppliedName(userSuppliedName, userSuppliedName, userSuppliedNameLocation);
    }

    public static MessagePlaceholder createWithUserSuppliedName(String name, String userSuppliedName, SourceLocation userSuppliedNameLocation) {
        return MessagePlaceholder.createWithUserSuppliedName(name, userSuppliedName, userSuppliedNameLocation, Optional.empty());
    }

    public static MessagePlaceholder createWithUserSuppliedName(String name, String userSuppliedName, SourceLocation userSuppliedNameLocation, Optional<String> example) {
        return new AutoValue_MessagePlaceholder(Summary.create(name, example), Optional.of(userSuppliedName), Optional.of(userSuppliedNameLocation));
    }

    public abstract Summary summary();

    public abstract Optional<String> userSuppliedName();

    public abstract Optional<SourceLocation> userSuppliedNameLocation();

    public String name() {
        return this.summary().name();
    }

    public Optional<String> example() {
        return this.summary().example();
    }

    @Immutable
    @AutoValue
    public static abstract class Summary {
        public static Summary create(String name) {
            return Summary.create(name, Optional.empty());
        }

        public static Summary create(String name, Optional<String> example) {
            return new AutoValue_MessagePlaceholder_Summary(name, example);
        }

        public abstract String name();

        public abstract Optional<String> example();
    }
}

