/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import java.util.List;
import java.util.stream.Collectors;

public final class ImportNode
extends AbstractSoyNode {
    private final ImmutableList<ImportedVar> identifiers;
    private final StringNode path;
    private final ImportType importType;

    public ImportNode(int id, SourceLocation location, StringNode path, List<ImportedVar> defns) {
        super(id, location);
        this.identifiers = ImmutableList.copyOf(defns);
        this.path = path;
        this.importType = ImportNode.importTypeForPath(path.getValue());
    }

    private ImportNode(ImportNode orig, CopyState copyState) {
        super(orig, copyState);
        this.identifiers = (ImmutableList)orig.identifiers.stream().map(ImportedVar::clone).collect(ImmutableList.toImmutableList());
        this.path = orig.path.copy(copyState);
        this.importType = orig.importType;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.IMPORT_NODE;
    }

    @Override
    public ImportNode copy(CopyState copyState) {
        return new ImportNode(this, copyState);
    }

    public boolean isSideEffectImport() {
        return this.identifiers.isEmpty();
    }

    public ImportType getImportType() {
        return this.importType;
    }

    private static ImportType importTypeForPath(String path) {
        if (path.endsWith(".proto")) {
            return ImportType.PROTO;
        }
        if (path.endsWith(".soy")) {
            return ImportType.TEMPLATE;
        }
        return ImportType.UNKNOWN;
    }

    public StringNode getPathNode() {
        return this.path;
    }

    public String getPath() {
        return this.path.getValue();
    }

    public boolean isModuleImport() {
        return this.identifiers.size() == 1 && ((ImportedVar)this.identifiers.get(0)).name().equals("*");
    }

    public String getModuleAlias() {
        Preconditions.checkState((boolean)this.isModuleImport(), (Object)"Module alias can only be retrieved for module imports (e.g. \"import * as fooTemplates from 'my_foo.soy';\")");
        return ((ImportedVar)this.identifiers.get(0)).getAlias();
    }

    public SourceLocation getPathSourceLocation() {
        return this.path.getSourceLocation();
    }

    public ImmutableList<ImportedVar> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public String toSourceString() {
        String exprs = "";
        if (!this.identifiers.isEmpty()) {
            exprs = String.format("{%s} from ", this.identifiers.stream().map(i -> i.isAliased() ? i.name() + " as " + i.getAlias() : i.name()).collect(Collectors.joining(",")));
        }
        return String.format("import %s'%s'", exprs, this.path.getValue());
    }

    public static enum ImportType {
        PROTO{

            @Override
            public boolean requiresSymbols() {
                return true;
            }
        }
        ,
        TEMPLATE{

            @Override
            public boolean requiresSymbols() {
                return true;
            }
        }
        ,
        UNKNOWN;


        public boolean allowsSymbols() {
            return true;
        }

        public boolean requiresSymbols() {
            return false;
        }
    }
}

